#include "db_pool.h"

#include "misc/dbpool/db_pool_impl.h"

#include <passport/infra/libs/cpp/utils/regular_task.h>

namespace NPassport::NDbPool2 {
    TDbPool::TDbPool(const NDbPool::TDbPoolSettings& settings, std::shared_ptr<TDbPoolCtx> ctx) {
        Y_ENSURE(settings.Dsn);
        auto decorated = NUtils::TRegularTaskDecorator<TDbPoolImpl>::CreateUnique(
            {
                TDuration::MilliSeconds(500),
                "dbpool2_" + settings.Dsn->Driver,
            },
            settings,
            ctx);
        decorated->RunRegularTaskNow(); // to create drivers immediately

        Impl_ = std::move(decorated);
    }

    TDbPool::~TDbPool() {
        Impl_->Stop(); // to reduce stopping duration
    }

    bool TDbPool::IsOk(TString* status) const {
        return Impl_->IsOk(status);
    }

    void TDbPool::TryPing() {
        Impl_->TryPing();
    }

    NDbPool::THandlesInfo TDbPool::GetHandlesInfo() const {
        return Impl_->GetHandlesInfo();
    }

    const NDbPool::TDbInfo& TDbPool::GetDbInfo() const {
        return Impl_->GetDbInfo();
    }

    typename TDbPool::TDriverPtr TDbPool::GetDriver() {
        return Impl_->GetDriver();
    }

    void TDbPool::PutGoodDriver(TDriverPtr driver) {
        Impl_->PutGoodDriver(std::move(driver));
    }

    void TDbPool::PutDriverWithError(TDriverPtr driver) {
        Impl_->PutDriverWithError(std::move(driver));
    }

    void TDbPool::PutDriverWithTimeOut(TDriverPtr driver) {
        Impl_->PutDriverWithTimeOut(std::move(driver));
    }

    TDbPoolCtx::TTimeStat TDbPool::GetTimeStats() const {
        return Impl_->GetTimeStats();
    }

    TDuration TDbPool::GetQueryTimeout() const {
        return Impl_->GetSettings().QueryTimeout;
    }

    TDbPoolLog TDbPool::GetLogger() const {
        return Impl_->GetLogger();
    }

    void TDbPool::IncAllRequests() {
        Impl_->IncAllRequests();
    }
}
