#pragma once

#include "db_pool_ctx.h"
#include "fwd.h"
#include "misc/driver/driver_error.h"
#include "misc/driver/driver_settings.h"

#include <passport/infra/libs/cpp/dbpool/db_pool.h>

namespace NPassport::NDbPool2 {
    class TDbPoolImpl;

    class TDbPool {
        using TDriverPtr = std::shared_ptr<IDriver>;

    public:
        TDbPool(const NDbPool::TDbPoolSettings& settings, TDbPoolCtxPtr ctx);
        ~TDbPool();

        bool IsOk(TString* status = nullptr) const;
        void TryPing();

        NDbPool::THandlesInfo GetHandlesInfo() const;
        const NDbPool::TDbInfo& GetDbInfo() const;

    private: // for THandle
        TDriverPtr GetDriver();
        void PutGoodDriver(TDriverPtr driver);
        void PutDriverWithError(TDriverPtr driver);
        void PutDriverWithTimeOut(TDriverPtr driver);
        TDbPoolCtx::TTimeStat GetTimeStats() const;
        TDuration GetQueryTimeout() const;
        TDbPoolLog GetLogger() const;
        void IncAllRequests();

    private:
        std::unique_ptr<TDbPoolImpl> Impl_;

        friend class THandle;
    };
}
