#pragma once

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TTimeStat;
    class TBuilder;
}

namespace NPassport::NDbPool {
    class TCounters;
}

namespace NPassport::NDbPool2 {
    class TDbPool;

    class TDbPoolCtx;
    using TDbPoolCtxPtr = std::shared_ptr<TDbPoolCtx>;

    class TDbPoolCtx: public std::enable_shared_from_this<TDbPoolCtx> {
    public:
        static TDbPoolCtxPtr Create();

        void InitLogger(const TString& fileName);
        void InitLogger(TDbPoolLog log);
        TDbPoolLog GetLogger() const;

        std::unique_ptr<TDbPool> CreateDb(const NXml::TConfig& config,
                                          const TString& xpath);

        std::unique_ptr<TDbPool> CreateDb(
            const NXml::TConfig& config,
            const TString& xpath_db,
            const TString& xpath_settings);

    public:
        using TTimeStat = std::shared_ptr<NUnistat::TTimeStat>;
        using TCounters = std::shared_ptr<NDbPool::TCounters>;

        void AddDbpool(TTimeStat st, TCounters c);
        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        std::vector<TTimeStat> TimeStats_;
        std::vector<TCounters> Counters_;
        TDbPoolLog Log_;
    };
}
