#include "db_pool_stats.h"

#include "db_pool.h"
#include "misc/driver/driver_error.h"

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/destination.h>

#include <util/generic/yexception.h>

namespace NPassport::NDbPool2 {
    static const TString TITLE = "monitoring status";
    TDbPoolStats::TDbPoolStats()
    {
        Init(TITLE);
    }

    TDbPoolStats::TDbPoolStats(const TString& title)
    {
        Init(title);
    }

    TDbPoolStats::~TDbPoolStats() = default;

    void TDbPoolStats::Add(NDbPool::TDbPool* db, const TString& comment) {
        AddImpl(db, comment);
    }

    void TDbPoolStats::Add(TDbPool* db, const TString& comment) {
        AddImpl(db, comment);
    }

    const TString& TDbPoolStats::Result() {
        if (!Finished_) {
            Finished_ = true;
            Buf_ << "</body></html>\r\n";
        }

        return Buf_.Str();
    }

    void TDbPoolStats::Init(const TString& title) {
        Buf_.Reserve(1024);
        Buf_ << "\r\n<html><head><title>" << title << "</title></head><body>\r\n";
    }

    template <class T>
    void TDbPoolStats::AddImpl(T* db, const TString& comment) {
        if (Finished_) {
            throw yexception() << "DbPoolStats result is finished!";
        }

        if (!db) {
            return;
        }

        const NDbPool::THandlesInfo info = db->GetHandlesInfo();

        Buf_ << "<p>";
        Buf_ << "db_name: " << db->GetDbInfo().DisplayName;
        Buf_ << ", idle: " << info.Idle;
        Buf_ << ", in_use: " << info.InUse;
        Buf_ << ", config_count: " << info.ConfigCount;
        Buf_ << ", comment: " << comment;
        Buf_ << ", dying: " << info.Dying;
        Buf_ << "</p>\r\n";
    }
}
