#pragma once

#include "fwd.h"

#include <util/stream/str.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NDbPool2 {
    class TDbPoolStats {
    public:
        TDbPoolStats();
        explicit TDbPoolStats(const TString& title);
        ~TDbPoolStats();

        void Add(NDbPool::TDbPool* db, const TString& comment = TString());
        void Add(NDbPool2::TDbPool* db, const TString& comment = TString());

        const TString& Result();

    private:
        void Init(const TString& title);

        template <class T>
        void AddImpl(T* db, const TString& comment = TString());

        bool Finished_ = false;
        TStringStream Buf_;
    };
}
