#pragma once

#include "misc/driver/driver.h"
#include "misc/driver/driver_error.h"

#include <passport/infra/libs/cpp/dbpool/query.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NPassport::NDbPool2 {
    class TDbPool;

    class TPoller;

    enum class EHandleState {
        ReadyForQuery,
        WaitingResult,
        Destroyed,
    };

    // Object cannot be reused after first query
    class THandle: TMoveOnly {
    public:
        THandle();

        THandle(TDbPool& dbpool); // TODO: TMP: uses thread local poller
        THandle(TDbPool& dbpool, TPoller& poller);
        ~THandle();

        THandle(THandle&&) noexcept;
        THandle& operator=(THandle&&) noexcept;

        TString EscapeQueryParam(const TString& str) const;

        THandle& SendQuery(NDbPool::TQuery&& query);
        NDbPool::TTable ExtractResult(TDuration customTimeout = {});

        explicit operator bool() const {
            return (bool)Driver_;
        }

    private:
        void ProcessResponseTime();

    private:
        TDbPool* Dbpool_ = nullptr;
        TPoller* Poller_ = nullptr;
        std::shared_ptr<IDriver> Driver_;

        EHandleState State_ = EHandleState::ReadyForQuery;
        IDriver::TResultType Future_;
        TInstant QueryStart_;
    };
}
