#pragma once

#include <passport/infra/libs/cpp/dbpool2/db_pool.h>

#include <passport/infra/libs/cpp/dbpool/misc/counter.h>
#include <passport/infra/libs/cpp/dbpool/misc/poolstate.h>

#include <util/thread/lfqueue.h>

namespace NPassport::NDbPool2 {
    class TPoller;

    class TDbPoolImpl {
        using TDriverPtr = std::shared_ptr<IDriver>;

    public:
        TDbPoolImpl(const NDbPool::TDbPoolSettings& settings, std::shared_ptr<TDbPoolCtx> ctx);
        virtual ~TDbPoolImpl() = default;

    public: // for TDbPool
        void Stop();

        TDbPoolCtx::TTimeStat GetTimeStats() const {
            return TimeStats_;
        }

        const NDbPool::TDbPoolSettings& GetSettings() const {
            return Settings_;
        }

        bool IsOk(TString* status) const;
        void TryPing();

        NDbPool::THandlesInfo GetHandlesInfo() const;
        const NDbPool::TDbInfo& GetDbInfo() const;

        TDriverPtr GetDriver();
        void PutGoodDriver(TDriverPtr driver);

        void PutDriverWithError(TDriverPtr driver);
        void PutDriverWithTimeOut(TDriverPtr driver);

        TDbPoolLog GetLogger() const {
            return Log_;
        }

        void IncAllRequests();

    public: // for routine
        void PutPingedDriver(TDriverPtr driver);

        bool IsTimeToPing() const;
        size_t NeedMoreDrivers() const;
        size_t DriversCanBeCreated() const;

        void TryMakeStateUp();
        void AddNewDriver(TDriverPtr driver);

        void Run();

        const char* GetDsn();

    private:
        static TDriverDestination CreateDriverDestination(const NDbPool::TDbPoolSettings& settings);
        static size_t CreateSizeLimit(const NDbPool::TDbPoolSettings& settings);
        static TDbPoolCtx::TTimeStat CreateTimeStats(const NDbPool::TDbPoolSettings& settings);

    private:
        const NDbPool::TDbPoolSettings Settings_;
        const TDriverDestination Destination_;
        const size_t SizeLimit_ = 0;

        const TDbPoolLog Log_;

        const TDbPoolCtx::TTimeStat TimeStats_;
        const std::shared_ptr<NDbPool::TCounters> Counters_;

        NDbPool::TDbInfo DbInfo_;

        TLockFreeQueue<TDriverPtr> IdleDrivers_;

        TInstant LastSuccessfulPing_;
        NDbPool::TPoolState State_;

        std::atomic_bool Stopping_ = {false};
    };
}
