#pragma once

#include <passport/infra/libs/cpp/dbpool2/misc/driver/driver.h>

namespace NPassport::NDbPool2 {
    class TDbPoolImpl;
    class TPoller;

    // Creates and prepares new driver for dbpool
    class TDriverEmbryo {
    public:
        TDriverEmbryo(TDbPoolImpl& parent, TPoller& poller);
        ~TDriverEmbryo();

        bool IsTimeToLeave();

    private:
        bool IsTimeToLeaveImpl();

        enum EState {
            Connecting,
            Preparing,
            Prepared,
            Error,
        };

    private:
        TDbPoolImpl* Parent_;
        TPoller* Poller_;
        TDbPoolLog Log_;
        std::shared_ptr<IDriver> Driver_;
        TInstant StartTime_;
        IDriver::TResultFuture<bool> FutureConnect_;
        IDriver::TResultType FuturePrepare_;
        EState State_ = Connecting;
    };

    // Creates number of drivers - simultaneously
    class TDriverCreator {
    public:
        TDriverCreator(TDbPoolImpl& parent, TPoller& poller);

        bool DoesNeedMoreLoop();

    private:
        TDbPoolImpl& Parent_;
        TPoller& Poller_;
        std::vector<TDriverEmbryo> Drivers_;
    };
}
