#pragma once

#include <passport/infra/libs/cpp/dbpool2/misc/driver/driver.h>

namespace NPassport::NDbPool2 {
    class TDbPoolImpl;
    class TPoller;

    class TDriverGuard {
    public:
        TDriverGuard(TDbPoolImpl& parent);
        ~TDriverGuard();

        ui64 GetDriverId();
        std::shared_ptr<IDriver>& MutateDriver();

    protected:
        TDbPoolImpl* Parent_;

    private:
        std::shared_ptr<IDriver> Driver_;
    };

    class TPingSubject: TDriverGuard {
    public:
        TPingSubject(TDbPoolImpl& parent, TPoller& poller);

        bool IsTimeToLeave();
        bool IsTimeToLeaveImpl();

    private:
        TPoller* Poller_;
        TDbPoolLog Log_;
        IDriver::TResultFuture<bool> Future_;
        TInstant StartTime_;
        bool IsFinished_ = false;
    };

    class TDriverPinger {
    public:
        TDriverPinger(TDbPoolImpl& parent, TPoller& poller);

        bool DoesNeedMoreLoop();

    private:
        TDbPoolImpl& Parent_;
        TPoller& Poller_;
        std::optional<TPingSubject> PingSubject_;
    };
}
