#include "driver.h"

#include "mysql_driver.h"
#include "sqlite_driver.h"

#include <util/random/easy.h>

namespace NPassport::NDbPool2 {
    IPollAble::IPollAble()
        : Id_(Random())
    {
    }

    std::shared_ptr<IDriver> IDriver::CreateDriver(const TString& type) {
        if (type == "mysql") {
            return std::make_shared<TMysqlDriver>();
        }

        if (type == "sqlite") {
            return std::make_shared<TSqliteDriver>();
        }

        ythrow yexception() << "unsupported driver type: " << type;
    }
}
