#pragma once

#include "driver_error.h"
#include "driver_settings.h"

#include <passport/infra/libs/cpp/dbpool/query.h>
#include <passport/infra/libs/cpp/dbpool/value.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/threading/future/future.h>

#include <util/network/init.h>

#include <variant>

namespace NPassport::NDbPool2 {
    // Entry for TPoller
    class IPollAble {
    public:
        IPollAble();
        virtual ~IPollAble() = default;

        virtual void OnPollEvent() = 0;
        virtual SOCKET GetSocket() const = 0;

        ui64 GetId() const noexcept {
            return Id_;
        }

    private:
        const ui64 Id_;
    };
    using TPollAblePtr = std::shared_ptr<IPollAble>;
    static const inline SOCKET DUMMY_SOCKET = -100500; // for synchronous entries

    // Entry to process query
    class IDriver: public IPollAble {
    public:
        template <class T>
        using TErrorOr = std::variant<T, TDriverError>;
        template <class T>
        using TResultFuture = NThreading::TFuture<TErrorOr<T>>;

        using TResultType = TResultFuture<NDbPool::TTable>;

        struct TPreparePolicy {
            TString LocaleCmd;
        };

        virtual TResultType StartSendingQuery(NDbPool::TQuery&&) = 0;

        virtual void Init(const TDriverSettings& settings) = 0;
        virtual TResultFuture<bool> StartConnecting() = 0;
        virtual bool IsReadyForQuery() const noexcept = 0;
        virtual TDriverDestination GetDestination() const = 0;
        virtual TResultFuture<bool> StartPinging() = 0;
        virtual TString EscapeQueryParam(const TString& str) const = 0;

        static std::shared_ptr<IDriver> CreateDriver(const TString& type);
    };
}
