#pragma once

#include <passport/infra/libs/cpp/dbpool/db_pool.h>

#include <util/generic/string.h>

namespace NPassport::NDbPool2 {
    struct TDriverSettings {
        TDriverSettings() = default;

        TDriverSettings(const NDbPool::TDbPoolSettings& settings)
            : Host(settings.Hosts.at(0).Host)
            , Port(settings.Hosts.at(0).Port)
            , Dsn(settings.Dsn)
        {
            Y_ENSURE(Dsn);
        }

        TString Host;
        ui16 Port = 0;
        NDbPool::TDestinationPtr Dsn;

        TString SerializedDestination;
    };
}
