#pragma once

#include "driver.h"

#include <passport/infra/libs/cpp/dbpool/misc/mysql-driver.h>

#include <contrib/libs/libmysql_r/include/mysql.h>

namespace NPassport::NDbPool2 {
    class TMysqlDriver: public IDriver {
    public:
        TMysqlDriver();
        ~TMysqlDriver() override;

        void OnPollEvent() override;
        SOCKET GetSocket() const override;

        void Init(const TDriverSettings& settings) override;
        TResultFuture<bool> StartConnecting() override;
        bool IsReadyForQuery() const noexcept override;
        TDriverDestination GetDestination() const override;
        IDriver::TResultFuture<bool> StartPinging() override;
        TString EscapeQueryParam(const TString& str) const override;

        TResultType StartSendingQuery(NDbPool::TQuery&& query) override;

    public:
        enum class EState {
            NotInited,
            Inited,
            Connecting,
            Connected,
            SendingQuery,
            StoringResult,
            FetchingRows,
            FreeingResult,
            Error,
        };

        class TMySqlHolder: public MYSQL {
        public:
            TMySqlHolder();
            ~TMySqlHolder();
        };

        enum class EProcessResult {
            ContinueCycle,
            BackToPoller,
        };

    private:
        EProcessResult Proccess();

        bool Connect();
        bool SendQuery();
        bool StoreResult();
        bool FetchRows();
        bool FreeResult();

        NDbPool::TRow BuildRow() const;

        static void InitMysql();
        bool IsReady(net_async_status status) const;
        void SetState(EState state);
        TDriverError GetErrorInfo(TStringBuf what);

    private:
        const NDbPool::TMySqlLibHolder::TLib LibHolder_;
        TDriverSettings Settings_;

        TMySqlHolder Handle_;

        EState State_ = EState::NotInited;
        EState PreviousState_ = State_;

        struct TPerQuery {
            TPerQuery(NDbPool::TQuery&& query = {});
            ~TPerQuery();

            TPerQuery(TPerQuery&&) = default;
            TPerQuery& operator=(TPerQuery&&) = default;

        public:
            NThreading::TPromise<TErrorOr<bool>> PromiseConnecting;
            NThreading::TPromise<TErrorOr<NDbPool::TTable>> Promise;
            NDbPool::TQuery Query;
            NDbPool::TTable Result;
            MYSQL_RES* MysqlResult = nullptr;
            MYSQL_ROW MysqlRow = nullptr;
        } PerQuery_;
    };
}
