#pragma once

#include "driver.h"

#include <contrib/libs/sqlite3/sqlite3.h>

namespace NPassport::NDbPool2 {
    class TSqliteDriver: public IDriver {
    public:
        TSqliteDriver();
        ~TSqliteDriver() override;

        void OnPollEvent() override;
        SOCKET GetSocket() const override;

        void Init(const TDriverSettings& settings) override;
        TResultFuture<bool> StartConnecting() override;
        bool IsReadyForQuery() const noexcept override;
        TDriverDestination GetDestination() const override;
        IDriver::TResultFuture<bool> StartPinging() override;
        TString EscapeQueryParam(const TString& str) const override;

        TResultType StartSendingQuery(NDbPool::TQuery&& query) override;

    private:
        TDriverError GetErrorInfo();

    private:
        std::unique_ptr<sqlite3, std::function<int(sqlite3*)>> Handle_;
        TDriverSettings Settings_;
    };
}
