#pragma once

#include "driver/driver.h"

#include <passport/infra/libs/cpp/dbpool/exception.h>

namespace NPassport::NDbPool2 {
    template <typename T, typename Func>
    void ThrowOnError(const IDriver::TErrorOr<T>& errorOrT, const TDbPoolLog& log, Func func) {
        if (const auto* err = std::get_if<TDriverError>(&errorOrT)) {
            func();
            log.Warning("%s: dr=%lu: driver got error: [%d] %s",
                        err->Destination.Serialized.c_str(),
                        err->Destination.Id,
                        err->Code,
                        err->Msg.c_str());
            throw NDbPool::TException(err->Destination.Serialized)
                << "failed to perform query"
                << ". error<" << err->Code << ">: " << err->Msg;
        }
    }
}
