#include "poller.h"

#include <util/thread/singleton.h>

#include <vector>

namespace NPassport::NDbPool2 {
    TPoller::TPoller() {
        Events_.resize(16);
    }

    TPoller::~TPoller() = default;

    void TPoller::Add(TPollAblePtr pollable) {
        Y_ENSURE(pollable);
        const SOCKET s = pollable->GetSocket();
        if (DUMMY_SOCKET == s) {
            return;
        }

        Sockpoller_.WaitRead(s, pollable.get()); // thread-safe syscall. can throw
        Pollables_.emplace(std::move(pollable));
    }

    void TPoller::Forget(const TPollAblePtr& pollable) {
        Y_ENSURE(pollable);
        const SOCKET s = pollable->GetSocket();
        if (DUMMY_SOCKET == s) {
            return;
        }

        Sockpoller_.Unwait(s); // thread-safe syscall
        Pollables_.erase(pollable);
    }

    void TPoller::RunLoopOnce(TDuration timeout) {
        RunLoopOnce(timeout.ToDeadLine());
    }

    void TPoller::RunLoopOnce(TInstant deadline) {
        const size_t ret = Sockpoller_.WaitD(Events_.data(), Events_.size(), deadline);

        for (size_t idx = 0; idx < ret && idx < Events_.size(); ++idx) {
            IPollAble* pollable = (IPollAble*)Events_[idx];
            pollable->OnPollEvent();
        }

        if (ret >= Events_.size()) {
            Events_.resize(2 * Events_.size());
        }
    }

    void TPoller::ForgetAll() {
        for (const TPollAblePtr& p : Pollables_) {
            Sockpoller_.Unwait(p->GetSocket());
        }
        Pollables_.clear();
    }

    TPoller& GetThreadLocalPoller() {
        return *FastTlsSingleton<TPoller>();
    }
}
