#pragma once

#include "misc/driver/driver.h"

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/network/init.h>
#include <util/network/poller.h>

#include <set>

namespace NPassport::NDbPool2 {
    // thread unsafe
    class TPoller {
    public:
        TPoller();
        ~TPoller();

        void Add(TPollAblePtr pollable);
        void Forget(const TPollAblePtr& pollable);

        void RunLoopOnce(TDuration timeout);
        void RunLoopOnce(TInstant deadline);
        void ForgetAll();

    protected:
        TSocketPoller Sockpoller_;
        TSmallVec<void*> Events_;

        std::set<TPollAblePtr> Pollables_;
    };

    TPoller& GetThreadLocalPoller();
}
