#include "utils.h"

#include "db_pool.h"
#include "handle.h"

#include <passport/infra/libs/cpp/dbpool/exception.h>

namespace NPassport::NDbPool2::NUtils {
    TResponseWithRetries DoQueryTries(TDbPool& db, const TString& query, ui16 tries) {
        size_t retries = 0;

        while (tries--) {
            try {
                THandle sqlh(db);
                return {sqlh.SendQuery(query).ExtractResult(), retries};
            } catch (const NDbPool::TException& e) {
                TLog::Debug("Request failed: %s. Retries left: %d. Reason: %s",
                            query.c_str(),
                            tries,
                            e.what());
            }

            // Let backend to catch his breath
            Sleep(TDuration::Seconds(1));
            ++retries;
        }

        ythrow NDbPool::TException(db.GetDbInfo().Serialized)
            << "Failed to make reliable fetching"
            << ". Query: " << query;
    }
}
