#pragma once

#include "iss_nkms_client.h"
#include "iss_parts_fetcher.h"

#include <passport/infra/libs/cpp/auth_core/gamma/gamma_keeper.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NGammaFetcher {
    class TFetcher {
    public:
        struct TGammas {
            NAuth::TGammaKeeperSettings::TGammas Gammas;
            NAuth::TGammaId SigningGamma = 0;
        };

        static TGammas FetchGammas(TIssPartFetcherPtr issPartsFetcher,
                                   const NXml::TConfig& config,
                                   const TString& xpath);

    public:
        static NAuth::EEnitityType GetType(const TString& type, const TString& path);

        static NAuth::TGammaKeeperSettings::TGammas InitGammas(
            TIssPartFetcherPtr issPartsFetcher,
            const NXml::TConfig& config,
            const TString& xpath);
        static TIssNkmsClient::TGammaParts FetchIssParts(
            TIssPartFetcherPtr issPartsFetcher,
            const NXml::TConfig& config,
            const TString& xpath);
        static NAuth::TGamma ReadSingleGamma(
            const TIssNkmsClient::TGammaParts& issParts,
            const TIssNkmsClient::TGammaParts& passpParts,
            const NXml::TConfig& config,
            const TString& xpath);

    private:
        static void CheckKeyringsCacheBehaviour();
    };
}
