#pragma once

#include <passport/infra/libs/cpp/auth_core/gamma/gamma_keeper.h>

#include <library/cpp/http/io/headers.h>

#include <util/generic/string.h>

namespace NPassport::NGammaFetcher {
    class TTskvLog;

    class TIssNkmsClient {
    public:
        using TGammaParts = std::map<NAuth::TGammaId, TString>;

        static TString Fetch(
            const TString& url,
            const TString& nameSpace,
            const TString& envType,
            const TString& serviceTicket,
            const TString& rsaKeysDir,
            const TTskvLog& log);

        static TGammaParts ParseResponse(const TStringBuf body);

    public:
        struct TEncryptedResponse {
            ui32 KeyId = 0;
            TString EncryptedSessKey;
            TString Iv;
            TString EncryptedBody;
        };

        struct TRequest {
            TString Host;
            ui16 Port = 0;
            TString Path;
            THashMap<TString, TString> Headers;

            TString GetUrl() const;
        };

        struct TRawResponse {
            ui32 Code = 0;
            THttpHeaders Headers;
            TString Body;
        };

        static TRequest BuildRequest(const TString& url,
                                     const TString& nameSpace,
                                     const TString& envType,
                                     const TString& serviceTicket);
        static TRawResponse FetchRaw(const TRequest& req);
        static TEncryptedResponse ParseRawResponse(const TRequest& request, TRawResponse&& resp);
        static TString DecryptResponse(const TEncryptedResponse& response, const TString& rsaKeysDir);
    };
}
