#pragma once

#include <util/generic/string.h>

#include <memory>

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NGammaFetcher {
    class TTskvLog;

    class IIssPartFetcher {
    public:
        virtual ~IIssPartFetcher() = default;
        virtual TString GetFromCache() const = 0;
        virtual TString Fetch() const = 0;
    };

    using TIssPartFetcherPtr = std::unique_ptr<IIssPartFetcher>;

    class TIssPartBaseFetcher: public IIssPartFetcher {
    public:
        TIssPartBaseFetcher(const NXml::TConfig& config,
                            const TString& xpath);
        ~TIssPartBaseFetcher() override = default;

        static TIssPartFetcherPtr Create(const NXml::TConfig& config,
                                         const TString& xpath,
                                         std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);

        TString GetFromCache() const override;
        TString Fetch() const override;

    public:
        virtual TString FetchImpl(const TString& url) const = 0;
        static TString GetUrl(const NXml::TConfig& config, const TString& xpath);

    private:
        bool IsKeyringEnabled() const;
        TString GetKeyringsName() const;

    protected:
        std::unique_ptr<TTskvLog> GammaLogger_;
        const NXml::TConfig& Config_;
        const TString& Xpath_;
    };

    class TDiskFetcher: public TIssPartBaseFetcher {
    public:
        TDiskFetcher(const NXml::TConfig& config,
                     const TString& xpath);

        TString FetchImpl(const TString& url) const override;
    };

    class THttpFetcher: public TIssPartBaseFetcher {
    public:
        THttpFetcher(const NXml::TConfig& config,
                     const TString& xpath,
                     std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);
        ~THttpFetcher() override;

        TString FetchImpl(const TString& url) const override;

    private:
        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;
    };
}
