#include "logger.h"

#include <passport/infra/libs/cpp/utils/log/logger.h>

#include <library/cpp/string_utils/tskv_format/builder.h>

#include <util/datetime/base.h>
#include <util/system/hostname.h>

namespace NPassport::NGammaFetcher {
    TTskvLog::TTskvLog(std::unique_ptr<NUtils::ILogger> logger)
        : Logger_(std::move(logger))
    {
    }

    TTskvLog::~TTskvLog() = default;

    void TTskvLog::LogGammaFetch(bool success,
                                 const TStringBuf url,
                                 const TStringBuf message) const {
        NTskvFormat::TLogBuilder builder;
        builder.Str().reserve(512);
        builder.Begin("gamma-log", time(nullptr));
        builder.AddUnescaped("action", "fetch_gamma");
        builder.AddUnescaped("hostname", FQDNHostName());
        builder.AddUnescaped("time", TInstant::Now().ToStringLocal());
        builder.Add("url", url);
        builder.AddUnescaped("status", success ? "OK" : "FAIL");
        if (message) {
            builder.Add("reason", message);
        }

        Logger_->Log(std::move(builder.End().Str()));
    }
}
