#include <passport/infra/libs/cpp/gamma_fetcher/logger.h>

#include <passport/infra/libs/cpp/utils/thread_local_id.h>
#include <passport/infra/libs/cpp/utils/log/file_logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NGammaFetcher;

Y_UNIT_TEST_SUITE(TskvLog) {
    static const TString tmpFileName("tmp_log_file");

    Y_UNIT_TEST(gamma) {
        NFs::Remove(tmpFileName);
        std::unique_ptr<NUtils::TFileLogger> log;

        UNIT_ASSERT_NO_EXCEPTION(log = std::make_unique<NUtils::TFileLogger>(tmpFileName, "DEBUG", true));
        {
            TTskvLog tskv_log(std::move(log));

            TString request_id("test_req_id");
            NUtils::SetThreadLocalRequestId(&request_id);

            tskv_log.LogGammaFetch(true, "URL", "no error");
            tskv_log.LogGammaFetch(false, "another URL", "some\terror\tmessage");
        }

        {
            TFileInput log_file(tmpFileName);
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\turl=URL\tstatus=OK\treason=no error");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\turl=another URL\tstatus=FAIL\treason=some\\terror\\tmessage");
        }
    }
}
