#include "geobase.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/file.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/geobase/lookup.hpp>

namespace NPassport::NGeobase {
    TGeobase::TGeobase(const TString& filename) {
        Loader_ = std::make_unique<NUtils::TFileLoader>(
            filename,
            [this](const TString& filename) {
                Lookup_.Set(std::make_shared<::NGeobase::TLookup>(filename));
            },
            TDuration::Minutes(1));
    }

    TGeobase::~TGeobase() = default;

    std::optional<ui32> TGeobase::GetRegionId(const std::string& ip) const {
        try {
            return Lookup_.Get()->GetRegionByIp(ip).GetId();
        } catch (const std::exception& e) {
            ++UnistatErrors_;
        }

        return {};
    }

    std::optional<std::string> TGeobase::GetAs(const std::string& ip) const {
        try {
            // https://a.yandex-team.ru/arc/trunk/arcadia/passport/backend/core/geobase/geobase.py?rev=5995965#L57
            // get only first AS
            auto asTraits = Lookup_.Get()->GetAsTraitsByIp(ip);
            if (!asTraits.AsList.empty()) {
                return std::move(asTraits.AsList[0]);
            }

            return {};
        } catch (const std::exception& e) {
            ++UnistatErrors_;
        }

        return {};
    }

    void TGeobase::AddUnistat(NUnistat::TBuilder& builder) const {
        builder.Add(UnistatErrors_);
    }
}
