#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/generic/string.h>

#include <optional>

namespace NGeobase {
    class TLookup;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NUtils {
    class TFileLoader;
}

namespace NPassport::NGeobase {
    class IGeobase {
    public:
        virtual ~IGeobase() = default;
        virtual std::optional<ui32> GetRegionId(const std::string& ip) const = 0;
        virtual std::optional<std::string> GetAs(const std::string& ip) const = 0;

        virtual void AddUnistat(NUnistat::TBuilder&) const {
        }
    };

    using TGeobasePtr = std::unique_ptr<IGeobase>;

    class TGeobase: public IGeobase {
    public:
        TGeobase(const TString& filename);
        ~TGeobase() override;

        std::optional<ui32> GetRegionId(const std::string& ip) const override;
        std::optional<std::string> GetAs(const std::string& ip) const override;

        void AddUnistat(NUnistat::TBuilder& builder) const override;

    private:
        NUtils::TSharedState<::NGeobase::TLookup> Lookup_;
        mutable NUnistat::TSignalDiff<> UnistatErrors_ = {"depends.geobase.error"};

        // must be last
        std::unique_ptr<NUtils::TFileLoader> Loader_;
    };
}
