#pragma once

#include "hbase_pool.h"
#include "query.h"

#include <passport/infra/libs/cpp/utils/exponential_backoff.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <unordered_map>

namespace NPassport::NUnistat {
    class TTimeStat;
}

namespace NPassport::NHbase {
    using TTimeStatsPtr = std::shared_ptr<NUnistat::TTimeStat>;

    class TBatch {
    public:
        struct TSettings {
            size_t Limit = 5000;
            TDuration GetTimeout = TDuration::Seconds(60);
            ui32 Retries = 3;
            TDuration MinBackoff = TDuration::Seconds(15);
            TDuration MaxBackoff = TDuration::Seconds(150);

            int LogableIdx = 0;
            bool VerboseLogs = false;
        };

    public:
        TBatch(IHBasePool& pool,
               const TSettings& settings,
               TTimeStatsPtr stats = {},
               const TString& logableCookies = {});
        ~TBatch();

        void Add(const std::string& tableName, const TQueryArray& queries);

        size_t BatchCount() const {
            return BatchCount_;
        }

        size_t MutationsCount() const {
            return MutationCount_;
        }

        size_t RequestCount() const {
            return RequestCount_;
        }

    private:
        struct TRequest: TMoveOnly {
            TClientGuard Client;
            std::string TableName;
            std::vector<TGeneratedBatch> Batches;
            TInstant Start = TInstant::Now();
            ui32 Tries = 0;
        };

        using TPreparedRows = std::unordered_map<TString, TGeneratedBatch>;

    private:
        static TPreparedRows PrepareRows(const TQueryArray& queries);
        void SplitAndSend(const std::string& tableName, TPreparedRows&& rows);

        void Send(const std::string& tableName, std::vector<TGeneratedBatch>&& batches);

        TClientGuard GetClient();

        bool SendBlocking(TRequest& r);

        void ProcessResponse(TRequest& r);

    private:
        IHBasePool& Pool_;
        const TSettings Settings_;
        const TString LogableCookies_;
        TTimeStatsPtr Stats_;
        size_t BatchCount_ = 0;
        size_t MutationCount_ = 0;
        size_t RequestCount_ = 0;
        size_t SucceedCount_ = 0;
        NUtils::TExponentialBackoff Backoff_;
    };
}
