/**
 * Autogenerated by Thrift Compiler (1.0.0-dev)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#pragma once

#include "hbase_types.h"

#include <thrift/TDispatchProcessor.h>
#include <thrift/async/TConcurrentClientSyncInfo.h>

namespace apache { namespace hadoop { namespace hbase { namespace thrift {

#ifdef _MSC_VER
  #pragma warning( push )
  #pragma warning (disable : 4250 ) //inheriting methods via dominance
#endif

class HbaseIf {
 public:
  virtual ~HbaseIf() {}

  /**
   * Brings a table on-line (enables it)
   *
   * @param tableName name of the table
   */
  virtual void EnableTable(const Bytes& tableName) = 0;

  /**
   * Disables a table (takes it off-line) If it is being served, the master
   * will tell the servers to stop serving it.
   *
   * @param tableName name of the table
   */
  virtual void DisableTable(const Bytes& tableName) = 0;

  /**
   * @return true if table is on-line
   *
   * @param tableName name of the table to check
   */
  virtual bool IsTableEnabled(const Bytes& tableName) = 0;
  virtual void Compact(const Bytes& tableNameOrRegionName) = 0;
  virtual void MajorCompact(const Bytes& tableNameOrRegionName) = 0;

  /**
   * List all the userspace tables.
   *
   * @return returns a list of names
   */
  virtual void GetTableNames(std::vector<Text> & _return) = 0;

  /**
   * List all the column families assoicated with a table.
   *
   * @return list of column family descriptors
   *
   * @param tableName table name
   */
  virtual void GetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return, const Text& tableName) = 0;

  /**
   * List the regions associated with a table.
   *
   * @return list of region descriptors
   *
   * @param tableName table name
   */
  virtual void GetTableRegions(std::vector<TRegionInfo> & _return, const Text& tableName) = 0;

  /**
   * Create a table with the specified column families.  The name
   * field for each ColumnDescriptor must be set and must end in a
   * colon (:). All other fields are optional and will get default
   * values if not explicitly specified.
   *
   * @throws IllegalArgument if an input parameter is invalid
   *
   * @throws AlreadyExists if the table name already exists
   *
   * @param tableName name of table to create
   *
   * @param columnFamilies list of column family descriptors
   */
  virtual void CreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies) = 0;

  /**
   * Deletes a table
   *
   * @throws IOError if table doesn't exist on server or there was some other
   * problem
   *
   * @param tableName name of table to delete
   */
  virtual void DeleteTable(const Text& tableName) = 0;

  /**
   * Get a single TCell for the specified table, row, and column at the
   * latest timestamp. Returns an empty list if no such value exists.
   *
   * @return value for specified row/column
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param column column name
   *
   * @param attributes Get attributes
   */
  virtual void Get(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified number of versions for the specified table,
   * row, and column.
   *
   * @return list of cells for specified row/column
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param column column name
   *
   * @param numVersions number of versions to retrieve
   *
   * @param attributes Get attributes
   */
  virtual void GetVer(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified number of versions for the specified table,
   * row, and column.  Only versions less than or equal to the specified
   * timestamp will be returned.
   *
   * @return list of cells for specified row/column
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param column column name
   *
   * @param timestamp timestamp
   *
   * @param numVersions number of versions to retrieve
   *
   * @param attributes Get attributes
   */
  virtual void GetVerTs(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get all the data for the specified table and row at the latest
   * timestamp. Returns an empty list if the row does not exist.
   *
   * @return TRowResult containing the row and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param attributes Get attributes
   */
  virtual void GetRow(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified columns for the specified table and row at the latest
   * timestamp. Returns an empty list if the row does not exist.
   *
   * @return TRowResult containing the row and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param columns List of columns to return, null for all columns
   *
   * @param attributes Get attributes
   */
  virtual void GetRowWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get all the data for the specified table and row at the specified
   * timestamp. Returns an empty list if the row does not exist.
   *
   * @return TRowResult containing the row and map of columns to TCells
   *
   * @param tableName name of the table
   *
   * @param row row key
   *
   * @param timestamp timestamp
   *
   * @param attributes Get attributes
   */
  virtual void GetRowTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified columns for the specified table and row at the specified
   * timestamp. Returns an empty list if the row does not exist.
   *
   * @return TRowResult containing the row and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param columns List of columns to return, null for all columns
   *
   * @param timestamp
   * @param attributes Get attributes
   */
  virtual void GetRowWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get all the data for the specified table and rows at the latest
   * timestamp. Returns an empty list if no rows exist.
   *
   * @return TRowResult containing the rows and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param rows row keys
   *
   * @param attributes Get attributes
   */
  virtual void GetRows(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified columns for the specified table and rows at the latest
   * timestamp. Returns an empty list if no rows exist.
   *
   * @return TRowResult containing the rows and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param rows row keys
   *
   * @param columns List of columns to return, null for all columns
   *
   * @param attributes Get attributes
   */
  virtual void GetRowsWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get all the data for the specified table and rows at the specified
   * timestamp. Returns an empty list if no rows exist.
   *
   * @return TRowResult containing the rows and map of columns to TCells
   *
   * @param tableName name of the table
   *
   * @param rows row keys
   *
   * @param timestamp timestamp
   *
   * @param attributes Get attributes
   */
  virtual void GetRowsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get the specified columns for the specified table and rows at the specified
   * timestamp. Returns an empty list if no rows exist.
   *
   * @return TRowResult containing the rows and map of columns to TCells
   *
   * @param tableName name of table
   *
   * @param rows row keys
   *
   * @param columns List of columns to return, null for all columns
   *
   * @param timestamp
   * @param attributes Get attributes
   */
  virtual void GetRowsWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Apply a series of mutations (updates/deletes) to a row in a
   * single transaction.  If an exception is thrown, then the
   * transaction is aborted.  Default current timestamp is used, and
   * all entries will have an identical timestamp.
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param mutations list of mutation commands
   *
   * @param attributes Mutation attributes
   */
  virtual void MutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes) = 0;

  /**
   * Apply a series of mutations (updates/deletes) to a row in a
   * single transaction.  If an exception is thrown, then the
   * transaction is aborted.  The specified timestamp is used, and
   * all entries will have an identical timestamp.
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param mutations list of mutation commands
   *
   * @param timestamp timestamp
   *
   * @param attributes Mutation attributes
   */
  virtual void MutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Apply a series of batches (each a series of mutations on a single row)
   * in a single transaction.  If an exception is thrown, then the
   * transaction is aborted.  Default current timestamp is used, and
   * all entries will have an identical timestamp.
   *
   * @param tableName name of table
   *
   * @param rowBatches list of row batches
   *
   * @param attributes Mutation attributes
   */
  virtual void MutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes) = 0;

  /**
   * Apply a series of batches (each a series of mutations on a single row)
   * in a single transaction.  If an exception is thrown, then the
   * transaction is aborted.  The specified timestamp is used, and
   * all entries will have an identical timestamp.
   *
   * @param tableName name of table
   *
   * @param rowBatches list of row batches
   *
   * @param timestamp timestamp
   *
   * @param attributes Mutation attributes
   */
  virtual void MutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Atomically increment the column value specified.  Returns the next value post increment.
   *
   * @param tableName name of table
   *
   * @param row row to increment
   *
   * @param column name of column
   *
   * @param value amount to increment by
   */
  virtual int64_t AtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value) = 0;

  /**
   * Delete all cells that match the passed row and column.
   *
   * @param tableName name of table
   *
   * @param row Row to update
   *
   * @param column name of column whose value is to be deleted
   *
   * @param attributes Delete attributes
   */
  virtual void DeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes) = 0;

  /**
   * Delete all cells that match the passed row and column and whose
   * timestamp is equal-to or older than the passed timestamp.
   *
   * @param tableName name of table
   *
   * @param row Row to update
   *
   * @param column name of column whose value is to be deleted
   *
   * @param timestamp timestamp
   *
   * @param attributes Delete attributes
   */
  virtual void DeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Completely delete the row's cells.
   *
   * @param tableName name of table
   *
   * @param row key of the row to be completely deleted.
   *
   * @param attributes Delete attributes
   */
  virtual void DeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes) = 0;

  /**
   * Increment a cell by the ammount.
   * Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
   * False is the default.  Turn to true if you need the extra performance and can accept some
   * data loss if a thrift server dies with increments still in the queue.
   *
   * @param increment The single increment to apply
   */
  virtual void Increment(const TIncrement& increment) = 0;
  virtual void IncrementRows(const std::vector<TIncrement> & increments) = 0;

  /**
   * Completely delete the row's cells marked with a timestamp
   * equal-to or older than the passed timestamp.
   *
   * @param tableName name of table
   *
   * @param row key of the row to be completely deleted.
   *
   * @param timestamp timestamp
   *
   * @param attributes Delete attributes
   */
  virtual void DeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get a scanner on the current table, using the Scan instance
   * for the scan parameters.
   *
   * @param tableName name of table
   *
   * @param scan Scan instance
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get a scanner on the current table starting at the specified row and
   * ending at the last row in the table.  Return the specified columns.
   *
   * @return scanner id to be used with other scanner procedures
   *
   * @param tableName name of table
   *
   * @param startRow Starting row in table to scan.
   * Send "" (empty string) to start at the first row.
   *
   * @param columns columns to scan. If column name is a column family, all
   * columns of the specified column family are returned. It's also possible
   * to pass a regex in the column qualifier.
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get a scanner on the current table starting and stopping at the
   * specified rows.  ending at the last row in the table.  Return the
   * specified columns.
   *
   * @return scanner id to be used with other scanner procedures
   *
   * @param tableName name of table
   *
   * @param startRow Starting row in table to scan.
   * Send "" (empty string) to start at the first row.
   *
   * @param stopRow row to stop scanning on. This row is *not* included in the
   * scanner's results
   *
   * @param columns columns to scan. If column name is a column family, all
   * columns of the specified column family are returned. It's also possible
   * to pass a regex in the column qualifier.
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) = 0;

  /**
   * Open a scanner for a given prefix.  That is all rows will have the specified
   * prefix. No other rows will be returned.
   *
   * @return scanner id to use with other scanner calls
   *
   * @param tableName name of table
   *
   * @param startAndPrefix the prefix (and thus start row) of the keys you want
   *
   * @param columns the columns you want returned
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get a scanner on the current table starting at the specified row and
   * ending at the last row in the table.  Return the specified columns.
   * Only values with the specified timestamp are returned.
   *
   * @return scanner id to be used with other scanner procedures
   *
   * @param tableName name of table
   *
   * @param startRow Starting row in table to scan.
   * Send "" (empty string) to start at the first row.
   *
   * @param columns columns to scan. If column name is a column family, all
   * columns of the specified column family are returned. It's also possible
   * to pass a regex in the column qualifier.
   *
   * @param timestamp timestamp
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Get a scanner on the current table starting and stopping at the
   * specified rows.  ending at the last row in the table.  Return the
   * specified columns.  Only values with the specified timestamp are
   * returned.
   *
   * @return scanner id to be used with other scanner procedures
   *
   * @param tableName name of table
   *
   * @param startRow Starting row in table to scan.
   * Send "" (empty string) to start at the first row.
   *
   * @param stopRow row to stop scanning on. This row is *not* included in the
   * scanner's results
   *
   * @param columns columns to scan. If column name is a column family, all
   * columns of the specified column family are returned. It's also possible
   * to pass a regex in the column qualifier.
   *
   * @param timestamp timestamp
   *
   * @param attributes Scan attributes
   */
  virtual ScannerID ScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) = 0;

  /**
   * Returns the scanner's current row value and advances to the next
   * row in the table.  When there are no more rows in the table, or a key
   * greater-than-or-equal-to the scanner's specified stopRow is reached,
   * an empty list is returned.
   *
   * @return a TRowResult containing the current row and a map of the columns to TCells.
   *
   * @throws IllegalArgument if ScannerID is invalid
   *
   * @throws NotFound when the scanner reaches the end
   *
   * @param id id of a scanner returned by scannerOpen
   */
  virtual void ScannerGet(std::vector<TRowResult> & _return, const ScannerID id) = 0;

  /**
   * Returns, starting at the scanner's current row value nbRows worth of
   * rows and advances to the next row in the table.  When there are no more
   * rows in the table, or a key greater-than-or-equal-to the scanner's
   * specified stopRow is reached,  an empty list is returned.
   *
   * @return a TRowResult containing the current row and a map of the columns to TCells.
   *
   * @throws IllegalArgument if ScannerID is invalid
   *
   * @throws NotFound when the scanner reaches the end
   *
   * @param id id of a scanner returned by scannerOpen
   *
   * @param nbRows number of results to return
   */
  virtual void ScannerGetList(std::vector<TRowResult> & _return, const ScannerID id, const int32_t nbRows) = 0;

  /**
   * Closes the server-state associated with an open scanner.
   *
   * @throws IllegalArgument if ScannerID is invalid
   *
   * @param id id of a scanner returned by scannerOpen
   */
  virtual void ScannerClose(const ScannerID id) = 0;

  /**
   * Get the row just before the specified one.
   *
   * @return value for specified row/column
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param family column name
   */
  virtual void GetRowOrBefore(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& family) = 0;

  /**
   * Get the regininfo for the specified row. It scans
   * the metatable to find region's start and end keys.
   *
   * @return value for specified row/column
   *
   * @param row row key
   */
  virtual void GetRegionInfo(TRegionInfo& _return, const Text& row) = 0;

  /**
   * Appends values to one or more columns within a single row.
   *
   * @return values of columns after the append operation.
   *
   * @param append The single append operation to apply
   */
  virtual void Append(std::vector<TCell> & _return, const TAppend& append) = 0;

  /**
   * Atomically checks if a row/family/qualifier value matches the expected
   * value. If it does, it adds the corresponding mutation operation for put.
   *
   * @return true if the new put was executed, false otherwise
   *
   * @param tableName name of table
   *
   * @param row row key
   *
   * @param column column name
   *
   * @param value the expected value for the column parameter, if not
   * provided the check is for the non-existence of the
   * column in question
   *
   * @param mput mutation for the put
   *
   * @param attributes Mutation attributes
   */
  virtual bool CheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes) = 0;
};

class HbaseIfFactory {
 public:
  typedef HbaseIf Handler;

  virtual ~HbaseIfFactory() {}

  virtual HbaseIf* GetHandler(const ::apache::thrift::TConnectionInfo& connInfo) = 0;
  // NOLINTNEXTLINE(readability-identifier-naming)
  virtual void releaseHandler(HbaseIf* /* handler */) = 0;
};

class HbaseIfSingletonFactory : virtual public HbaseIfFactory {
 public:
  HbaseIfSingletonFactory(const ::apache::thrift::stdcxx::shared_ptr<HbaseIf>& iface) : Iface_(iface) {}
  virtual ~HbaseIfSingletonFactory() {}

  virtual HbaseIf* GetHandler(const ::apache::thrift::TConnectionInfo&) {
    return Iface_.get();
  }
  virtual void releaseHandler(HbaseIf* /* handler */) {}

 protected:
  ::apache::thrift::stdcxx::shared_ptr<HbaseIf> Iface_;
};

class HbaseNull : virtual public HbaseIf {
 public:
  virtual ~HbaseNull() {}
  void EnableTable(const Bytes& /* tableName */) {
    return;
  }
  void DisableTable(const Bytes& /* tableName */) {
    return;
  }
  bool IsTableEnabled(const Bytes& /* tableName */) {
    bool _return = false;
    return _return;
  }
  void Compact(const Bytes& /* tableNameOrRegionName */) {
    return;
  }
  void MajorCompact(const Bytes& /* tableNameOrRegionName */) {
    return;
  }
  void GetTableNames(std::vector<Text> & /* _return */) {
    return;
  }
  void GetColumnDescriptors(std::map<Text, ColumnDescriptor> & /* _return */, const Text& /* tableName */) {
    return;
  }
  void GetTableRegions(std::vector<TRegionInfo> & /* _return */, const Text& /* tableName */) {
    return;
  }
  void CreateTable(const Text& /* tableName */, const std::vector<ColumnDescriptor> & /* columnFamilies */) {
    return;
  }
  void DeleteTable(const Text& /* tableName */) {
    return;
  }
  void Get(std::vector<TCell> & /* _return */, const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetVer(std::vector<TCell> & /* _return */, const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const int32_t /* numVersions */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetVerTs(std::vector<TCell> & /* _return */, const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const int64_t /* timestamp */, const int32_t /* numVersions */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRow(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const Text& /* row */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowWithColumns(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const Text& /* row */, const std::vector<Text> & /* columns */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowTs(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const Text& /* row */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowWithColumnsTs(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const Text& /* row */, const std::vector<Text> & /* columns */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRows(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const std::vector<Text> & /* rows */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowsWithColumns(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const std::vector<Text> & /* rows */, const std::vector<Text> & /* columns */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowsTs(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const std::vector<Text> & /* rows */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void GetRowsWithColumnsTs(std::vector<TRowResult> & /* _return */, const Text& /* tableName */, const std::vector<Text> & /* rows */, const std::vector<Text> & /* columns */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void MutateRow(const Text& /* tableName */, const Text& /* row */, const std::vector<Mutation> & /* mutations */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void MutateRowTs(const Text& /* tableName */, const Text& /* row */, const std::vector<Mutation> & /* mutations */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void MutateRows(const Text& /* tableName */, const std::vector<BatchMutation> & /* rowBatches */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void MutateRowsTs(const Text& /* tableName */, const std::vector<BatchMutation> & /* rowBatches */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  int64_t AtomicIncrement(const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const int64_t /* value */) {
    int64_t _return = 0;
    return _return;
  }
  void DeleteAll(const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void DeleteAllTs(const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void DeleteAllRow(const Text& /* tableName */, const Text& /* row */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  void Increment(const TIncrement& /* increment */) {
    return;
  }
  void IncrementRows(const std::vector<TIncrement> & /* increments */) {
    return;
  }
  void DeleteAllRowTs(const Text& /* tableName */, const Text& /* row */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    return;
  }
  ScannerID ScannerOpenWithScan(const Text& /* tableName */, const TScan& /* scan */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  ScannerID ScannerOpen(const Text& /* tableName */, const Text& /* startRow */, const std::vector<Text> & /* columns */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  ScannerID ScannerOpenWithStop(const Text& /* tableName */, const Text& /* startRow */, const Text& /* stopRow */, const std::vector<Text> & /* columns */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  ScannerID ScannerOpenWithPrefix(const Text& /* tableName */, const Text& /* startAndPrefix */, const std::vector<Text> & /* columns */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  ScannerID ScannerOpenTs(const Text& /* tableName */, const Text& /* startRow */, const std::vector<Text> & /* columns */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  ScannerID ScannerOpenWithStopTs(const Text& /* tableName */, const Text& /* startRow */, const Text& /* stopRow */, const std::vector<Text> & /* columns */, const int64_t /* timestamp */, const std::map<Text, Text> & /* attributes */) {
    ScannerID _return = 0;
    return _return;
  }
  void ScannerGet(std::vector<TRowResult> & /* _return */, const ScannerID /* id */) {
    return;
  }
  void ScannerGetList(std::vector<TRowResult> & /* _return */, const ScannerID /* id */, const int32_t /* nbRows */) {
    return;
  }
  void ScannerClose(const ScannerID /* id */) {
    return;
  }
  void GetRowOrBefore(std::vector<TCell> & /* _return */, const Text& /* tableName */, const Text& /* row */, const Text& /* family */) {
    return;
  }
  void GetRegionInfo(TRegionInfo& /* _return */, const Text& /* row */) {
    return;
  }
  void Append(std::vector<TCell> & /* _return */, const TAppend& /* append */) {
    return;
  }
  bool CheckAndPut(const Text& /* tableName */, const Text& /* row */, const Text& /* column */, const Text& /* value */, const Mutation& /* mput */, const std::map<Text, Text> & /* attributes */) {
    bool _return = false;
    return _return;
  }
};

typedef struct HbaseEnableTableArgsIsset {
  HbaseEnableTableArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_enableTable_args__isset;

class HbaseEnableTableArgs {
 public:

  HbaseEnableTableArgs(const HbaseEnableTableArgs&);
  HbaseEnableTableArgs& operator=(const HbaseEnableTableArgs&);
  HbaseEnableTableArgs() : TableName() {
  }

  virtual ~HbaseEnableTableArgs() throw();
  Bytes TableName;

  _Hbase_enableTable_args__isset Isset;

  void SetTableName(const Bytes& val);

  bool operator == (const HbaseEnableTableArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseEnableTableArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseEnableTableArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseEnableTablePargs {
 public:


  virtual ~HbaseEnableTablePargs() throw();
  const Bytes* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseEnableTableResultIsset {
  HbaseEnableTableResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_enableTable_result__isset;

class HbaseEnableTableResult {
 public:

  HbaseEnableTableResult(const HbaseEnableTableResult&);
  HbaseEnableTableResult& operator=(const HbaseEnableTableResult&);
  HbaseEnableTableResult() {
  }

  virtual ~HbaseEnableTableResult() throw();
  IOError Io;

  _Hbase_enableTable_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseEnableTableResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseEnableTableResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseEnableTableResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseEnableTablePresultIsset {
  HbaseEnableTablePresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_enableTable_presult__isset;

class HbaseEnableTablePresult {
 public:


  virtual ~HbaseEnableTablePresult() throw();
  IOError Io;

  _Hbase_enableTable_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDisableTableArgsIsset {
  HbaseDisableTableArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_disableTable_args__isset;

class HbaseDisableTableArgs {
 public:

  HbaseDisableTableArgs(const HbaseDisableTableArgs&);
  HbaseDisableTableArgs& operator=(const HbaseDisableTableArgs&);
  HbaseDisableTableArgs() : TableName() {
  }

  virtual ~HbaseDisableTableArgs() throw();
  Bytes TableName;

  _Hbase_disableTable_args__isset Isset;

  void SetTableName(const Bytes& val);

  bool operator == (const HbaseDisableTableArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseDisableTableArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDisableTableArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDisableTablePargs {
 public:


  virtual ~HbaseDisableTablePargs() throw();
  const Bytes* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDisableTableResultIsset {
  HbaseDisableTableResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_disableTable_result__isset;

class HbaseDisableTableResult {
 public:

  HbaseDisableTableResult(const HbaseDisableTableResult&);
  HbaseDisableTableResult& operator=(const HbaseDisableTableResult&);
  HbaseDisableTableResult() {
  }

  virtual ~HbaseDisableTableResult() throw();
  IOError Io;

  _Hbase_disableTable_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDisableTableResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDisableTableResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDisableTableResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDisableTablePresultIsset {
  HbaseDisableTablePresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_disableTable_presult__isset;

class HbaseDisableTablePresult {
 public:


  virtual ~HbaseDisableTablePresult() throw();
  IOError Io;

  _Hbase_disableTable_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseIsTableEnabledArgsIsset {
  HbaseIsTableEnabledArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_isTableEnabled_args__isset;

class HbaseIsTableEnabledArgs {
 public:

  HbaseIsTableEnabledArgs(const HbaseIsTableEnabledArgs&);
  HbaseIsTableEnabledArgs& operator=(const HbaseIsTableEnabledArgs&);
  HbaseIsTableEnabledArgs() : TableName() {
  }

  virtual ~HbaseIsTableEnabledArgs() throw();
  Bytes TableName;

  _Hbase_isTableEnabled_args__isset Isset;

  void SetTableName(const Bytes& val);

  bool operator == (const HbaseIsTableEnabledArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseIsTableEnabledArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIsTableEnabledArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseIsTableEnabledPargs {
 public:


  virtual ~HbaseIsTableEnabledPargs() throw();
  const Bytes* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIsTableEnabledResultIsset {
  HbaseIsTableEnabledResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_isTableEnabled_result__isset;

class HbaseIsTableEnabledResult {
 public:

  HbaseIsTableEnabledResult(const HbaseIsTableEnabledResult&);
  HbaseIsTableEnabledResult& operator=(const HbaseIsTableEnabledResult&);
  HbaseIsTableEnabledResult() : Success(0) {
  }

  virtual ~HbaseIsTableEnabledResult() throw();
  bool Success;
  IOError Io;

  _Hbase_isTableEnabled_result__isset Isset;

  void SetSuccess(const bool val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseIsTableEnabledResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseIsTableEnabledResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIsTableEnabledResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIsTableEnabledPresultIsset {
  HbaseIsTableEnabledPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_isTableEnabled_presult__isset;

class HbaseIsTableEnabledPresult {
 public:


  virtual ~HbaseIsTableEnabledPresult() throw();
  bool* Success;
  IOError Io;

  _Hbase_isTableEnabled_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseCompactArgsIsset {
  HbaseCompactArgsIsset() : TableNameOrRegionName(false) {}
  bool TableNameOrRegionName :1;
} _Hbase_compact_args__isset;

class HbaseCompactArgs {
 public:

  HbaseCompactArgs(const HbaseCompactArgs&);
  HbaseCompactArgs& operator=(const HbaseCompactArgs&);
  HbaseCompactArgs() : TableNameOrRegionName() {
  }

  virtual ~HbaseCompactArgs() throw();
  Bytes TableNameOrRegionName;

  _Hbase_compact_args__isset Isset;

  void SetTableNameOrRegionName(const Bytes& val);

  bool operator == (const HbaseCompactArgs & rhs) const
  {
    if (!(TableNameOrRegionName == rhs.TableNameOrRegionName))
      return false;
    return true;
  }
  bool operator != (const HbaseCompactArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCompactArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseCompactPargs {
 public:


  virtual ~HbaseCompactPargs() throw();
  const Bytes* TableNameOrRegionName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCompactResultIsset {
  HbaseCompactResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_compact_result__isset;

class HbaseCompactResult {
 public:

  HbaseCompactResult(const HbaseCompactResult&);
  HbaseCompactResult& operator=(const HbaseCompactResult&);
  HbaseCompactResult() {
  }

  virtual ~HbaseCompactResult() throw();
  IOError Io;

  _Hbase_compact_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseCompactResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseCompactResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCompactResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCompactPresultIsset {
  HbaseCompactPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_compact_presult__isset;

class HbaseCompactPresult {
 public:


  virtual ~HbaseCompactPresult() throw();
  IOError Io;

  _Hbase_compact_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseMajorCompactArgsIsset {
  HbaseMajorCompactArgsIsset() : TableNameOrRegionName(false) {}
  bool TableNameOrRegionName :1;
} _Hbase_majorCompact_args__isset;

class HbaseMajorCompactArgs {
 public:

  HbaseMajorCompactArgs(const HbaseMajorCompactArgs&);
  HbaseMajorCompactArgs& operator=(const HbaseMajorCompactArgs&);
  HbaseMajorCompactArgs() : TableNameOrRegionName() {
  }

  virtual ~HbaseMajorCompactArgs() throw();
  Bytes TableNameOrRegionName;

  _Hbase_majorCompact_args__isset Isset;

  void SetTableNameOrRegionName(const Bytes& val);

  bool operator == (const HbaseMajorCompactArgs & rhs) const
  {
    if (!(TableNameOrRegionName == rhs.TableNameOrRegionName))
      return false;
    return true;
  }
  bool operator != (const HbaseMajorCompactArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMajorCompactArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseMajorCompactPargs {
 public:


  virtual ~HbaseMajorCompactPargs() throw();
  const Bytes* TableNameOrRegionName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMajorCompactResultIsset {
  HbaseMajorCompactResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_majorCompact_result__isset;

class HbaseMajorCompactResult {
 public:

  HbaseMajorCompactResult(const HbaseMajorCompactResult&);
  HbaseMajorCompactResult& operator=(const HbaseMajorCompactResult&);
  HbaseMajorCompactResult() {
  }

  virtual ~HbaseMajorCompactResult() throw();
  IOError Io;

  _Hbase_majorCompact_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseMajorCompactResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseMajorCompactResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMajorCompactResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMajorCompactPresultIsset {
  HbaseMajorCompactPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_majorCompact_presult__isset;

class HbaseMajorCompactPresult {
 public:


  virtual ~HbaseMajorCompactPresult() throw();
  IOError Io;

  _Hbase_majorCompact_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};


class HbaseGetTableNamesArgs {
 public:

  HbaseGetTableNamesArgs(const HbaseGetTableNamesArgs&);
  HbaseGetTableNamesArgs& operator=(const HbaseGetTableNamesArgs&);
  HbaseGetTableNamesArgs() {
  }

  virtual ~HbaseGetTableNamesArgs() throw();

  bool operator == (const HbaseGetTableNamesArgs & /* rhs */) const
  {
    return true;
  }
  bool operator != (const HbaseGetTableNamesArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetTableNamesArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetTableNamesPargs {
 public:


  virtual ~HbaseGetTableNamesPargs() throw();

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetTableNamesResultIsset {
  HbaseGetTableNamesResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getTableNames_result__isset;

class HbaseGetTableNamesResult {
 public:

  HbaseGetTableNamesResult(const HbaseGetTableNamesResult&);
  HbaseGetTableNamesResult& operator=(const HbaseGetTableNamesResult&);
  HbaseGetTableNamesResult() {
  }

  virtual ~HbaseGetTableNamesResult() throw();
  std::vector<Text>  Success;
  IOError Io;

  _Hbase_getTableNames_result__isset Isset;

  void SetSuccess(const std::vector<Text> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetTableNamesResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetTableNamesResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetTableNamesResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetTableNamesPresultIsset {
  HbaseGetTableNamesPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getTableNames_presult__isset;

class HbaseGetTableNamesPresult {
 public:


  virtual ~HbaseGetTableNamesPresult() throw();
  std::vector<Text> * Success;
  IOError Io;

  _Hbase_getTableNames_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetColumnDescriptorsArgsIsset {
  HbaseGetColumnDescriptorsArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_getColumnDescriptors_args__isset;

class HbaseGetColumnDescriptorsArgs {
 public:

  HbaseGetColumnDescriptorsArgs(const HbaseGetColumnDescriptorsArgs&);
  HbaseGetColumnDescriptorsArgs& operator=(const HbaseGetColumnDescriptorsArgs&);
  HbaseGetColumnDescriptorsArgs() : TableName() {
  }

  virtual ~HbaseGetColumnDescriptorsArgs() throw();
  Text TableName;

  _Hbase_getColumnDescriptors_args__isset Isset;

  void SetTableName(const Text& val);

  bool operator == (const HbaseGetColumnDescriptorsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseGetColumnDescriptorsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetColumnDescriptorsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetColumnDescriptorsPargs {
 public:


  virtual ~HbaseGetColumnDescriptorsPargs() throw();
  const Text* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetColumnDescriptorsResultIsset {
  HbaseGetColumnDescriptorsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getColumnDescriptors_result__isset;

class HbaseGetColumnDescriptorsResult {
 public:

  HbaseGetColumnDescriptorsResult(const HbaseGetColumnDescriptorsResult&);
  HbaseGetColumnDescriptorsResult& operator=(const HbaseGetColumnDescriptorsResult&);
  HbaseGetColumnDescriptorsResult() {
  }

  virtual ~HbaseGetColumnDescriptorsResult() throw();
  std::map<Text, ColumnDescriptor>  Success;
  IOError Io;

  _Hbase_getColumnDescriptors_result__isset Isset;

  void SetSuccess(const std::map<Text, ColumnDescriptor> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetColumnDescriptorsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetColumnDescriptorsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetColumnDescriptorsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetColumnDescriptorsPresultIsset {
  HbaseGetColumnDescriptorsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getColumnDescriptors_presult__isset;

class HbaseGetColumnDescriptorsPresult {
 public:


  virtual ~HbaseGetColumnDescriptorsPresult() throw();
  std::map<Text, ColumnDescriptor> * Success;
  IOError Io;

  _Hbase_getColumnDescriptors_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetTableRegionsArgsIsset {
  HbaseGetTableRegionsArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_getTableRegions_args__isset;

class HbaseGetTableRegionsArgs {
 public:

  HbaseGetTableRegionsArgs(const HbaseGetTableRegionsArgs&);
  HbaseGetTableRegionsArgs& operator=(const HbaseGetTableRegionsArgs&);
  HbaseGetTableRegionsArgs() : TableName() {
  }

  virtual ~HbaseGetTableRegionsArgs() throw();
  Text TableName;

  _Hbase_getTableRegions_args__isset Isset;

  void SetTableName(const Text& val);

  bool operator == (const HbaseGetTableRegionsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseGetTableRegionsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetTableRegionsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetTableRegionsPargs {
 public:


  virtual ~HbaseGetTableRegionsPargs() throw();
  const Text* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetTableRegionsResultIsset {
  HbaseGetTableRegionsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getTableRegions_result__isset;

class HbaseGetTableRegionsResult {
 public:

  HbaseGetTableRegionsResult(const HbaseGetTableRegionsResult&);
  HbaseGetTableRegionsResult& operator=(const HbaseGetTableRegionsResult&);
  HbaseGetTableRegionsResult() {
  }

  virtual ~HbaseGetTableRegionsResult() throw();
  std::vector<TRegionInfo>  Success;
  IOError Io;

  _Hbase_getTableRegions_result__isset Isset;

  void SetSuccess(const std::vector<TRegionInfo> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetTableRegionsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetTableRegionsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetTableRegionsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetTableRegionsPresultIsset {
  HbaseGetTableRegionsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getTableRegions_presult__isset;

class HbaseGetTableRegionsPresult {
 public:


  virtual ~HbaseGetTableRegionsPresult() throw();
  std::vector<TRegionInfo> * Success;
  IOError Io;

  _Hbase_getTableRegions_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseCreateTableArgsIsset {
  HbaseCreateTableArgsIsset() : TableName(false), ColumnFamilies(false) {}
  bool TableName :1;
  bool ColumnFamilies :1;
} _Hbase_createTable_args__isset;

class HbaseCreateTableArgs {
 public:

  HbaseCreateTableArgs(const HbaseCreateTableArgs&);
  HbaseCreateTableArgs& operator=(const HbaseCreateTableArgs&);
  HbaseCreateTableArgs() : TableName() {
  }

  virtual ~HbaseCreateTableArgs() throw();
  Text TableName;
  std::vector<ColumnDescriptor>  ColumnFamilies;

  _Hbase_createTable_args__isset Isset;

  void SetTableName(const Text& val);

  void SetColumnFamilies(const std::vector<ColumnDescriptor> & val);

  bool operator == (const HbaseCreateTableArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(ColumnFamilies == rhs.ColumnFamilies))
      return false;
    return true;
  }
  bool operator != (const HbaseCreateTableArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCreateTableArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseCreateTablePargs {
 public:


  virtual ~HbaseCreateTablePargs() throw();
  const Text* TableName;
  const std::vector<ColumnDescriptor> * ColumnFamilies;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCreateTableResultIsset {
  HbaseCreateTableResultIsset() : Io(false), Ia(false), Exist(false) {}
  bool Io :1;
  bool Ia :1;
  bool Exist :1;
} _Hbase_createTable_result__isset;

class HbaseCreateTableResult {
 public:

  HbaseCreateTableResult(const HbaseCreateTableResult&);
  HbaseCreateTableResult& operator=(const HbaseCreateTableResult&);
  HbaseCreateTableResult() {
  }

  virtual ~HbaseCreateTableResult() throw();
  IOError Io;
  IllegalArgument Ia;
  AlreadyExists Exist;

  _Hbase_createTable_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  void SetExist(const AlreadyExists& val);

  bool operator == (const HbaseCreateTableResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    if (!(Exist == rhs.Exist))
      return false;
    return true;
  }
  bool operator != (const HbaseCreateTableResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCreateTableResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCreateTablePresultIsset {
  HbaseCreateTablePresultIsset() : Io(false), Ia(false), Exist(false) {}
  bool Io :1;
  bool Ia :1;
  bool Exist :1;
} _Hbase_createTable_presult__isset;

class HbaseCreateTablePresult {
 public:


  virtual ~HbaseCreateTablePresult() throw();
  IOError Io;
  IllegalArgument Ia;
  AlreadyExists Exist;

  _Hbase_createTable_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDeleteTableArgsIsset {
  HbaseDeleteTableArgsIsset() : TableName(false) {}
  bool TableName :1;
} _Hbase_deleteTable_args__isset;

class HbaseDeleteTableArgs {
 public:

  HbaseDeleteTableArgs(const HbaseDeleteTableArgs&);
  HbaseDeleteTableArgs& operator=(const HbaseDeleteTableArgs&);
  HbaseDeleteTableArgs() : TableName() {
  }

  virtual ~HbaseDeleteTableArgs() throw();
  Text TableName;

  _Hbase_deleteTable_args__isset Isset;

  void SetTableName(const Text& val);

  bool operator == (const HbaseDeleteTableArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteTableArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteTableArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDeleteTablePargs {
 public:


  virtual ~HbaseDeleteTablePargs() throw();
  const Text* TableName;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteTableResultIsset {
  HbaseDeleteTableResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteTable_result__isset;

class HbaseDeleteTableResult {
 public:

  HbaseDeleteTableResult(const HbaseDeleteTableResult&);
  HbaseDeleteTableResult& operator=(const HbaseDeleteTableResult&);
  HbaseDeleteTableResult() {
  }

  virtual ~HbaseDeleteTableResult() throw();
  IOError Io;

  _Hbase_deleteTable_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDeleteTableResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteTableResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteTableResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteTablePresultIsset {
  HbaseDeleteTablePresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteTable_presult__isset;

class HbaseDeleteTablePresult {
 public:


  virtual ~HbaseDeleteTablePresult() throw();
  IOError Io;

  _Hbase_deleteTable_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetArgsIsset {
  HbaseGetArgsIsset() : TableName(false), Row(false), Column(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Attributes :1;
} _Hbase_get_args__isset;

class HbaseGetArgs {
 public:

  HbaseGetArgs(const HbaseGetArgs&);
  HbaseGetArgs& operator=(const HbaseGetArgs&);
  HbaseGetArgs() : TableName(), Row(), Column() {
  }

  virtual ~HbaseGetArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  std::map<Text, Text>  Attributes;

  _Hbase_get_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetPargs {
 public:


  virtual ~HbaseGetPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetResultIsset {
  HbaseGetResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_get_result__isset;

class HbaseGetResult {
 public:

  HbaseGetResult(const HbaseGetResult&);
  HbaseGetResult& operator=(const HbaseGetResult&);
  HbaseGetResult() {
  }

  virtual ~HbaseGetResult() throw();
  std::vector<TCell>  Success;
  IOError Io;

  _Hbase_get_result__isset Isset;

  void SetSuccess(const std::vector<TCell> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetPresultIsset {
  HbaseGetPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_get_presult__isset;

class HbaseGetPresult {
 public:


  virtual ~HbaseGetPresult() throw();
  std::vector<TCell> * Success;
  IOError Io;

  _Hbase_get_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetVerArgsIsset {
  HbaseGetVerArgsIsset() : TableName(false), Row(false), Column(false), NumVersions(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool NumVersions :1;
  bool Attributes :1;
} _Hbase_getVer_args__isset;

class HbaseGetVerArgs {
 public:

  HbaseGetVerArgs(const HbaseGetVerArgs&);
  HbaseGetVerArgs& operator=(const HbaseGetVerArgs&);
  HbaseGetVerArgs() : TableName(), Row(), Column(), NumVersions(0) {
  }

  virtual ~HbaseGetVerArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  int32_t NumVersions;
  std::map<Text, Text>  Attributes;

  _Hbase_getVer_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetNumVersions(const int32_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetVerArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(NumVersions == rhs.NumVersions))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetVerArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetVerArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetVerPargs {
 public:


  virtual ~HbaseGetVerPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const int32_t* NumVersions;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetVerResultIsset {
  HbaseGetVerResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getVer_result__isset;

class HbaseGetVerResult {
 public:

  HbaseGetVerResult(const HbaseGetVerResult&);
  HbaseGetVerResult& operator=(const HbaseGetVerResult&);
  HbaseGetVerResult() {
  }

  virtual ~HbaseGetVerResult() throw();
  std::vector<TCell>  Success;
  IOError Io;

  _Hbase_getVer_result__isset Isset;

  void SetSuccess(const std::vector<TCell> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetVerResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetVerResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetVerResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetVerPresultIsset {
  HbaseGetVerPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getVer_presult__isset;

class HbaseGetVerPresult {
 public:


  virtual ~HbaseGetVerPresult() throw();
  std::vector<TCell> * Success;
  IOError Io;

  _Hbase_getVer_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetVerTsArgsIsset {
  HbaseGetVerTsArgsIsset() : TableName(false), Row(false), Column(false), Timestamp(false), NumVersions(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Timestamp :1;
  bool NumVersions :1;
  bool Attributes :1;
} _Hbase_getVerTs_args__isset;

class HbaseGetVerTsArgs {
 public:

  HbaseGetVerTsArgs(const HbaseGetVerTsArgs&);
  HbaseGetVerTsArgs& operator=(const HbaseGetVerTsArgs&);
  HbaseGetVerTsArgs() : TableName(), Row(), Column(), Timestamp(0), NumVersions(0) {
  }

  virtual ~HbaseGetVerTsArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  int64_t Timestamp;
  int32_t NumVersions;
  std::map<Text, Text>  Attributes;

  _Hbase_getVerTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetTimestamp(const int64_t val);

  void SetNumVersions(const int32_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetVerTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(NumVersions == rhs.NumVersions))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetVerTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetVerTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetVerTsPargs {
 public:


  virtual ~HbaseGetVerTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const int64_t* Timestamp;
  const int32_t* NumVersions;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetVerTsResultIsset {
  HbaseGetVerTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getVerTs_result__isset;

class HbaseGetVerTsResult {
 public:

  HbaseGetVerTsResult(const HbaseGetVerTsResult&);
  HbaseGetVerTsResult& operator=(const HbaseGetVerTsResult&);
  HbaseGetVerTsResult() {
  }

  virtual ~HbaseGetVerTsResult() throw();
  std::vector<TCell>  Success;
  IOError Io;

  _Hbase_getVerTs_result__isset Isset;

  void SetSuccess(const std::vector<TCell> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetVerTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetVerTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetVerTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetVerTsPresultIsset {
  HbaseGetVerTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getVerTs_presult__isset;

class HbaseGetVerTsPresult {
 public:


  virtual ~HbaseGetVerTsPresult() throw();
  std::vector<TCell> * Success;
  IOError Io;

  _Hbase_getVerTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowArgsIsset {
  HbaseGetRowArgsIsset() : TableName(false), Row(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Attributes :1;
} _Hbase_getRow_args__isset;

class HbaseGetRowArgs {
 public:

  HbaseGetRowArgs(const HbaseGetRowArgs&);
  HbaseGetRowArgs& operator=(const HbaseGetRowArgs&);
  HbaseGetRowArgs() : TableName(), Row() {
  }

  virtual ~HbaseGetRowArgs() throw();
  Text TableName;
  Text Row;
  std::map<Text, Text>  Attributes;

  _Hbase_getRow_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowPargs {
 public:


  virtual ~HbaseGetRowPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowResultIsset {
  HbaseGetRowResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRow_result__isset;

class HbaseGetRowResult {
 public:

  HbaseGetRowResult(const HbaseGetRowResult&);
  HbaseGetRowResult& operator=(const HbaseGetRowResult&);
  HbaseGetRowResult() {
  }

  virtual ~HbaseGetRowResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRow_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowPresultIsset {
  HbaseGetRowPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRow_presult__isset;

class HbaseGetRowPresult {
 public:


  virtual ~HbaseGetRowPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRow_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowWithColumnsArgsIsset {
  HbaseGetRowWithColumnsArgsIsset() : TableName(false), Row(false), Columns(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Columns :1;
  bool Attributes :1;
} _Hbase_getRowWithColumns_args__isset;

class HbaseGetRowWithColumnsArgs {
 public:

  HbaseGetRowWithColumnsArgs(const HbaseGetRowWithColumnsArgs&);
  HbaseGetRowWithColumnsArgs& operator=(const HbaseGetRowWithColumnsArgs&);
  HbaseGetRowWithColumnsArgs() : TableName(), Row() {
  }

  virtual ~HbaseGetRowWithColumnsArgs() throw();
  Text TableName;
  Text Row;
  std::vector<Text>  Columns;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowWithColumns_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowWithColumnsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowWithColumnsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowWithColumnsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowWithColumnsPargs {
 public:


  virtual ~HbaseGetRowWithColumnsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::vector<Text> * Columns;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowWithColumnsResultIsset {
  HbaseGetRowWithColumnsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowWithColumns_result__isset;

class HbaseGetRowWithColumnsResult {
 public:

  HbaseGetRowWithColumnsResult(const HbaseGetRowWithColumnsResult&);
  HbaseGetRowWithColumnsResult& operator=(const HbaseGetRowWithColumnsResult&);
  HbaseGetRowWithColumnsResult() {
  }

  virtual ~HbaseGetRowWithColumnsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowWithColumns_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowWithColumnsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowWithColumnsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowWithColumnsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowWithColumnsPresultIsset {
  HbaseGetRowWithColumnsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowWithColumns_presult__isset;

class HbaseGetRowWithColumnsPresult {
 public:


  virtual ~HbaseGetRowWithColumnsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowWithColumns_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowTsArgsIsset {
  HbaseGetRowTsArgsIsset() : TableName(false), Row(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_getRowTs_args__isset;

class HbaseGetRowTsArgs {
 public:

  HbaseGetRowTsArgs(const HbaseGetRowTsArgs&);
  HbaseGetRowTsArgs& operator=(const HbaseGetRowTsArgs&);
  HbaseGetRowTsArgs() : TableName(), Row(), Timestamp(0) {
  }

  virtual ~HbaseGetRowTsArgs() throw();
  Text TableName;
  Text Row;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowTsPargs {
 public:


  virtual ~HbaseGetRowTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowTsResultIsset {
  HbaseGetRowTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowTs_result__isset;

class HbaseGetRowTsResult {
 public:

  HbaseGetRowTsResult(const HbaseGetRowTsResult&);
  HbaseGetRowTsResult& operator=(const HbaseGetRowTsResult&);
  HbaseGetRowTsResult() {
  }

  virtual ~HbaseGetRowTsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowTs_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowTsPresultIsset {
  HbaseGetRowTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowTs_presult__isset;

class HbaseGetRowTsPresult {
 public:


  virtual ~HbaseGetRowTsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowWithColumnsTsArgsIsset {
  HbaseGetRowWithColumnsTsArgsIsset() : TableName(false), Row(false), Columns(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Columns :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_getRowWithColumnsTs_args__isset;

class HbaseGetRowWithColumnsTsArgs {
 public:

  HbaseGetRowWithColumnsTsArgs(const HbaseGetRowWithColumnsTsArgs&);
  HbaseGetRowWithColumnsTsArgs& operator=(const HbaseGetRowWithColumnsTsArgs&);
  HbaseGetRowWithColumnsTsArgs() : TableName(), Row(), Timestamp(0) {
  }

  virtual ~HbaseGetRowWithColumnsTsArgs() throw();
  Text TableName;
  Text Row;
  std::vector<Text>  Columns;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowWithColumnsTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowWithColumnsTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowWithColumnsTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowWithColumnsTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowWithColumnsTsPargs {
 public:


  virtual ~HbaseGetRowWithColumnsTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::vector<Text> * Columns;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowWithColumnsTsResultIsset {
  HbaseGetRowWithColumnsTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowWithColumnsTs_result__isset;

class HbaseGetRowWithColumnsTsResult {
 public:

  HbaseGetRowWithColumnsTsResult(const HbaseGetRowWithColumnsTsResult&);
  HbaseGetRowWithColumnsTsResult& operator=(const HbaseGetRowWithColumnsTsResult&);
  HbaseGetRowWithColumnsTsResult() {
  }

  virtual ~HbaseGetRowWithColumnsTsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowWithColumnsTs_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowWithColumnsTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowWithColumnsTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowWithColumnsTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowWithColumnsTsPresultIsset {
  HbaseGetRowWithColumnsTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowWithColumnsTs_presult__isset;

class HbaseGetRowWithColumnsTsPresult {
 public:


  virtual ~HbaseGetRowWithColumnsTsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowWithColumnsTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowsArgsIsset {
  HbaseGetRowsArgsIsset() : TableName(false), Rows(false), Attributes(false) {}
  bool TableName :1;
  bool Rows :1;
  bool Attributes :1;
} _Hbase_getRows_args__isset;

class HbaseGetRowsArgs {
 public:

  HbaseGetRowsArgs(const HbaseGetRowsArgs&);
  HbaseGetRowsArgs& operator=(const HbaseGetRowsArgs&);
  HbaseGetRowsArgs() : TableName() {
  }

  virtual ~HbaseGetRowsArgs() throw();
  Text TableName;
  std::vector<Text>  Rows;
  std::map<Text, Text>  Attributes;

  _Hbase_getRows_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRows(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Rows == rhs.Rows))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowsPargs {
 public:


  virtual ~HbaseGetRowsPargs() throw();
  const Text* TableName;
  const std::vector<Text> * Rows;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsResultIsset {
  HbaseGetRowsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRows_result__isset;

class HbaseGetRowsResult {
 public:

  HbaseGetRowsResult(const HbaseGetRowsResult&);
  HbaseGetRowsResult& operator=(const HbaseGetRowsResult&);
  HbaseGetRowsResult() {
  }

  virtual ~HbaseGetRowsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRows_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsPresultIsset {
  HbaseGetRowsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRows_presult__isset;

class HbaseGetRowsPresult {
 public:


  virtual ~HbaseGetRowsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRows_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowsWithColumnsArgsIsset {
  HbaseGetRowsWithColumnsArgsIsset() : TableName(false), Rows(false), Columns(false), Attributes(false) {}
  bool TableName :1;
  bool Rows :1;
  bool Columns :1;
  bool Attributes :1;
} _Hbase_getRowsWithColumns_args__isset;

class HbaseGetRowsWithColumnsArgs {
 public:

  HbaseGetRowsWithColumnsArgs(const HbaseGetRowsWithColumnsArgs&);
  HbaseGetRowsWithColumnsArgs& operator=(const HbaseGetRowsWithColumnsArgs&);
  HbaseGetRowsWithColumnsArgs() : TableName() {
  }

  virtual ~HbaseGetRowsWithColumnsArgs() throw();
  Text TableName;
  std::vector<Text>  Rows;
  std::vector<Text>  Columns;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowsWithColumns_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRows(const std::vector<Text> & val);

  void SetColumns(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowsWithColumnsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Rows == rhs.Rows))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsWithColumnsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsWithColumnsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowsWithColumnsPargs {
 public:


  virtual ~HbaseGetRowsWithColumnsPargs() throw();
  const Text* TableName;
  const std::vector<Text> * Rows;
  const std::vector<Text> * Columns;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsWithColumnsResultIsset {
  HbaseGetRowsWithColumnsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsWithColumns_result__isset;

class HbaseGetRowsWithColumnsResult {
 public:

  HbaseGetRowsWithColumnsResult(const HbaseGetRowsWithColumnsResult&);
  HbaseGetRowsWithColumnsResult& operator=(const HbaseGetRowsWithColumnsResult&);
  HbaseGetRowsWithColumnsResult() {
  }

  virtual ~HbaseGetRowsWithColumnsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowsWithColumns_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowsWithColumnsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsWithColumnsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsWithColumnsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsWithColumnsPresultIsset {
  HbaseGetRowsWithColumnsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsWithColumns_presult__isset;

class HbaseGetRowsWithColumnsPresult {
 public:


  virtual ~HbaseGetRowsWithColumnsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowsWithColumns_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowsTsArgsIsset {
  HbaseGetRowsTsArgsIsset() : TableName(false), Rows(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Rows :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_getRowsTs_args__isset;

class HbaseGetRowsTsArgs {
 public:

  HbaseGetRowsTsArgs(const HbaseGetRowsTsArgs&);
  HbaseGetRowsTsArgs& operator=(const HbaseGetRowsTsArgs&);
  HbaseGetRowsTsArgs() : TableName(), Timestamp(0) {
  }

  virtual ~HbaseGetRowsTsArgs() throw();
  Text TableName;
  std::vector<Text>  Rows;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowsTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRows(const std::vector<Text> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowsTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Rows == rhs.Rows))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowsTsPargs {
 public:


  virtual ~HbaseGetRowsTsPargs() throw();
  const Text* TableName;
  const std::vector<Text> * Rows;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsTsResultIsset {
  HbaseGetRowsTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsTs_result__isset;

class HbaseGetRowsTsResult {
 public:

  HbaseGetRowsTsResult(const HbaseGetRowsTsResult&);
  HbaseGetRowsTsResult& operator=(const HbaseGetRowsTsResult&);
  HbaseGetRowsTsResult() {
  }

  virtual ~HbaseGetRowsTsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowsTs_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowsTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsTsPresultIsset {
  HbaseGetRowsTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsTs_presult__isset;

class HbaseGetRowsTsPresult {
 public:


  virtual ~HbaseGetRowsTsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowsTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowsWithColumnsTsArgsIsset {
  HbaseGetRowsWithColumnsTsArgsIsset() : TableName(false), Rows(false), Columns(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Rows :1;
  bool Columns :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_getRowsWithColumnsTs_args__isset;

class HbaseGetRowsWithColumnsTsArgs {
 public:

  HbaseGetRowsWithColumnsTsArgs(const HbaseGetRowsWithColumnsTsArgs&);
  HbaseGetRowsWithColumnsTsArgs& operator=(const HbaseGetRowsWithColumnsTsArgs&);
  HbaseGetRowsWithColumnsTsArgs() : TableName(), Timestamp(0) {
  }

  virtual ~HbaseGetRowsWithColumnsTsArgs() throw();
  Text TableName;
  std::vector<Text>  Rows;
  std::vector<Text>  Columns;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_getRowsWithColumnsTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRows(const std::vector<Text> & val);

  void SetColumns(const std::vector<Text> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseGetRowsWithColumnsTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Rows == rhs.Rows))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsWithColumnsTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsWithColumnsTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowsWithColumnsTsPargs {
 public:


  virtual ~HbaseGetRowsWithColumnsTsPargs() throw();
  const Text* TableName;
  const std::vector<Text> * Rows;
  const std::vector<Text> * Columns;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsWithColumnsTsResultIsset {
  HbaseGetRowsWithColumnsTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsWithColumnsTs_result__isset;

class HbaseGetRowsWithColumnsTsResult {
 public:

  HbaseGetRowsWithColumnsTsResult(const HbaseGetRowsWithColumnsTsResult&);
  HbaseGetRowsWithColumnsTsResult& operator=(const HbaseGetRowsWithColumnsTsResult&);
  HbaseGetRowsWithColumnsTsResult() {
  }

  virtual ~HbaseGetRowsWithColumnsTsResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;

  _Hbase_getRowsWithColumnsTs_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowsWithColumnsTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowsWithColumnsTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowsWithColumnsTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowsWithColumnsTsPresultIsset {
  HbaseGetRowsWithColumnsTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowsWithColumnsTs_presult__isset;

class HbaseGetRowsWithColumnsTsPresult {
 public:


  virtual ~HbaseGetRowsWithColumnsTsPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;

  _Hbase_getRowsWithColumnsTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseMutateRowArgsIsset {
  HbaseMutateRowArgsIsset() : TableName(false), Row(false), Mutations(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Mutations :1;
  bool Attributes :1;
} _Hbase_mutateRow_args__isset;

class HbaseMutateRowArgs {
 public:

  HbaseMutateRowArgs(const HbaseMutateRowArgs&);
  HbaseMutateRowArgs& operator=(const HbaseMutateRowArgs&);
  HbaseMutateRowArgs() : TableName(), Row() {
  }

  virtual ~HbaseMutateRowArgs() throw();
  Text TableName;
  Text Row;
  std::vector<Mutation>  Mutations;
  std::map<Text, Text>  Attributes;

  _Hbase_mutateRow_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetMutations(const std::vector<Mutation> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseMutateRowArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Mutations == rhs.Mutations))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseMutateRowPargs {
 public:


  virtual ~HbaseMutateRowPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::vector<Mutation> * Mutations;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowResultIsset {
  HbaseMutateRowResultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRow_result__isset;

class HbaseMutateRowResult {
 public:

  HbaseMutateRowResult(const HbaseMutateRowResult&);
  HbaseMutateRowResult& operator=(const HbaseMutateRowResult&);
  HbaseMutateRowResult() {
  }

  virtual ~HbaseMutateRowResult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRow_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseMutateRowResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowPresultIsset {
  HbaseMutateRowPresultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRow_presult__isset;

class HbaseMutateRowPresult {
 public:


  virtual ~HbaseMutateRowPresult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRow_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseMutateRowTsArgsIsset {
  HbaseMutateRowTsArgsIsset() : TableName(false), Row(false), Mutations(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Mutations :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_mutateRowTs_args__isset;

class HbaseMutateRowTsArgs {
 public:

  HbaseMutateRowTsArgs(const HbaseMutateRowTsArgs&);
  HbaseMutateRowTsArgs& operator=(const HbaseMutateRowTsArgs&);
  HbaseMutateRowTsArgs() : TableName(), Row(), Timestamp(0) {
  }

  virtual ~HbaseMutateRowTsArgs() throw();
  Text TableName;
  Text Row;
  std::vector<Mutation>  Mutations;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_mutateRowTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetMutations(const std::vector<Mutation> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseMutateRowTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Mutations == rhs.Mutations))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseMutateRowTsPargs {
 public:


  virtual ~HbaseMutateRowTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::vector<Mutation> * Mutations;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowTsResultIsset {
  HbaseMutateRowTsResultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRowTs_result__isset;

class HbaseMutateRowTsResult {
 public:

  HbaseMutateRowTsResult(const HbaseMutateRowTsResult&);
  HbaseMutateRowTsResult& operator=(const HbaseMutateRowTsResult&);
  HbaseMutateRowTsResult() {
  }

  virtual ~HbaseMutateRowTsResult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRowTs_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseMutateRowTsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowTsPresultIsset {
  HbaseMutateRowTsPresultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRowTs_presult__isset;

class HbaseMutateRowTsPresult {
 public:


  virtual ~HbaseMutateRowTsPresult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRowTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseMutateRowsArgsIsset {
  HbaseMutateRowsArgsIsset() : TableName(false), RowBatches(false), Attributes(false) {}
  bool TableName :1;
  bool RowBatches :1;
  bool Attributes :1;
} _Hbase_mutateRows_args__isset;

class HbaseMutateRowsArgs {
 public:

  HbaseMutateRowsArgs(const HbaseMutateRowsArgs&);
  HbaseMutateRowsArgs& operator=(const HbaseMutateRowsArgs&);
  HbaseMutateRowsArgs() : TableName() {
  }

  virtual ~HbaseMutateRowsArgs() throw();
  Text TableName;
  std::vector<BatchMutation>  RowBatches;
  std::map<Text, Text>  Attributes;

  _Hbase_mutateRows_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRowBatches(const std::vector<BatchMutation> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseMutateRowsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(RowBatches == rhs.RowBatches))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseMutateRowsPargs {
 public:


  virtual ~HbaseMutateRowsPargs() throw();
  const Text* TableName;
  const std::vector<BatchMutation> * RowBatches;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowsResultIsset {
  HbaseMutateRowsResultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRows_result__isset;

class HbaseMutateRowsResult {
 public:

  HbaseMutateRowsResult(const HbaseMutateRowsResult&);
  HbaseMutateRowsResult& operator=(const HbaseMutateRowsResult&);
  HbaseMutateRowsResult() {
  }

  virtual ~HbaseMutateRowsResult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRows_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseMutateRowsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowsPresultIsset {
  HbaseMutateRowsPresultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRows_presult__isset;

class HbaseMutateRowsPresult {
 public:


  virtual ~HbaseMutateRowsPresult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRows_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseMutateRowsTsArgsIsset {
  HbaseMutateRowsTsArgsIsset() : TableName(false), RowBatches(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool RowBatches :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_mutateRowsTs_args__isset;

class HbaseMutateRowsTsArgs {
 public:

  HbaseMutateRowsTsArgs(const HbaseMutateRowsTsArgs&);
  HbaseMutateRowsTsArgs& operator=(const HbaseMutateRowsTsArgs&);
  HbaseMutateRowsTsArgs() : TableName(), Timestamp(0) {
  }

  virtual ~HbaseMutateRowsTsArgs() throw();
  Text TableName;
  std::vector<BatchMutation>  RowBatches;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_mutateRowsTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRowBatches(const std::vector<BatchMutation> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseMutateRowsTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(RowBatches == rhs.RowBatches))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowsTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowsTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseMutateRowsTsPargs {
 public:


  virtual ~HbaseMutateRowsTsPargs() throw();
  const Text* TableName;
  const std::vector<BatchMutation> * RowBatches;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowsTsResultIsset {
  HbaseMutateRowsTsResultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRowsTs_result__isset;

class HbaseMutateRowsTsResult {
 public:

  HbaseMutateRowsTsResult(const HbaseMutateRowsTsResult&);
  HbaseMutateRowsTsResult& operator=(const HbaseMutateRowsTsResult&);
  HbaseMutateRowsTsResult() {
  }

  virtual ~HbaseMutateRowsTsResult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRowsTs_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseMutateRowsTsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseMutateRowsTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseMutateRowsTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseMutateRowsTsPresultIsset {
  HbaseMutateRowsTsPresultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_mutateRowsTs_presult__isset;

class HbaseMutateRowsTsPresult {
 public:


  virtual ~HbaseMutateRowsTsPresult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_mutateRowsTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseAtomicIncrementArgsIsset {
  HbaseAtomicIncrementArgsIsset() : TableName(false), Row(false), Column(false), Value(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Value :1;
} _Hbase_atomicIncrement_args__isset;

class HbaseAtomicIncrementArgs {
 public:

  HbaseAtomicIncrementArgs(const HbaseAtomicIncrementArgs&);
  HbaseAtomicIncrementArgs& operator=(const HbaseAtomicIncrementArgs&);
  HbaseAtomicIncrementArgs() : TableName(), Row(), Column(), Value(0) {
  }

  virtual ~HbaseAtomicIncrementArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  int64_t Value;

  _Hbase_atomicIncrement_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetValue(const int64_t val);

  bool operator == (const HbaseAtomicIncrementArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Value == rhs.Value))
      return false;
    return true;
  }
  bool operator != (const HbaseAtomicIncrementArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseAtomicIncrementArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseAtomicIncrementPargs {
 public:


  virtual ~HbaseAtomicIncrementPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const int64_t* Value;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseAtomicIncrementResultIsset {
  HbaseAtomicIncrementResultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_atomicIncrement_result__isset;

class HbaseAtomicIncrementResult {
 public:

  HbaseAtomicIncrementResult(const HbaseAtomicIncrementResult&);
  HbaseAtomicIncrementResult& operator=(const HbaseAtomicIncrementResult&);
  HbaseAtomicIncrementResult() : Success(0) {
  }

  virtual ~HbaseAtomicIncrementResult() throw();
  int64_t Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_atomicIncrement_result__isset Isset;

  void SetSuccess(const int64_t val);

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseAtomicIncrementResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseAtomicIncrementResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseAtomicIncrementResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseAtomicIncrementPresultIsset {
  HbaseAtomicIncrementPresultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_atomicIncrement_presult__isset;

class HbaseAtomicIncrementPresult {
 public:


  virtual ~HbaseAtomicIncrementPresult() throw();
  int64_t* Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_atomicIncrement_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDeleteAllArgsIsset {
  HbaseDeleteAllArgsIsset() : TableName(false), Row(false), Column(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Attributes :1;
} _Hbase_deleteAll_args__isset;

class HbaseDeleteAllArgs {
 public:

  HbaseDeleteAllArgs(const HbaseDeleteAllArgs&);
  HbaseDeleteAllArgs& operator=(const HbaseDeleteAllArgs&);
  HbaseDeleteAllArgs() : TableName(), Row(), Column() {
  }

  virtual ~HbaseDeleteAllArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  std::map<Text, Text>  Attributes;

  _Hbase_deleteAll_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseDeleteAllArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDeleteAllPargs {
 public:


  virtual ~HbaseDeleteAllPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllResultIsset {
  HbaseDeleteAllResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAll_result__isset;

class HbaseDeleteAllResult {
 public:

  HbaseDeleteAllResult(const HbaseDeleteAllResult&);
  HbaseDeleteAllResult& operator=(const HbaseDeleteAllResult&);
  HbaseDeleteAllResult() {
  }

  virtual ~HbaseDeleteAllResult() throw();
  IOError Io;

  _Hbase_deleteAll_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDeleteAllResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllPresultIsset {
  HbaseDeleteAllPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAll_presult__isset;

class HbaseDeleteAllPresult {
 public:


  virtual ~HbaseDeleteAllPresult() throw();
  IOError Io;

  _Hbase_deleteAll_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDeleteAllTsArgsIsset {
  HbaseDeleteAllTsArgsIsset() : TableName(false), Row(false), Column(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_deleteAllTs_args__isset;

class HbaseDeleteAllTsArgs {
 public:

  HbaseDeleteAllTsArgs(const HbaseDeleteAllTsArgs&);
  HbaseDeleteAllTsArgs& operator=(const HbaseDeleteAllTsArgs&);
  HbaseDeleteAllTsArgs() : TableName(), Row(), Column(), Timestamp(0) {
  }

  virtual ~HbaseDeleteAllTsArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_deleteAllTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseDeleteAllTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDeleteAllTsPargs {
 public:


  virtual ~HbaseDeleteAllTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllTsResultIsset {
  HbaseDeleteAllTsResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllTs_result__isset;

class HbaseDeleteAllTsResult {
 public:

  HbaseDeleteAllTsResult(const HbaseDeleteAllTsResult&);
  HbaseDeleteAllTsResult& operator=(const HbaseDeleteAllTsResult&);
  HbaseDeleteAllTsResult() {
  }

  virtual ~HbaseDeleteAllTsResult() throw();
  IOError Io;

  _Hbase_deleteAllTs_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDeleteAllTsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllTsPresultIsset {
  HbaseDeleteAllTsPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllTs_presult__isset;

class HbaseDeleteAllTsPresult {
 public:


  virtual ~HbaseDeleteAllTsPresult() throw();
  IOError Io;

  _Hbase_deleteAllTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDeleteAllRowArgsIsset {
  HbaseDeleteAllRowArgsIsset() : TableName(false), Row(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Attributes :1;
} _Hbase_deleteAllRow_args__isset;

class HbaseDeleteAllRowArgs {
 public:

  HbaseDeleteAllRowArgs(const HbaseDeleteAllRowArgs&);
  HbaseDeleteAllRowArgs& operator=(const HbaseDeleteAllRowArgs&);
  HbaseDeleteAllRowArgs() : TableName(), Row() {
  }

  virtual ~HbaseDeleteAllRowArgs() throw();
  Text TableName;
  Text Row;
  std::map<Text, Text>  Attributes;

  _Hbase_deleteAllRow_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseDeleteAllRowArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllRowArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllRowArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDeleteAllRowPargs {
 public:


  virtual ~HbaseDeleteAllRowPargs() throw();
  const Text* TableName;
  const Text* Row;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllRowResultIsset {
  HbaseDeleteAllRowResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllRow_result__isset;

class HbaseDeleteAllRowResult {
 public:

  HbaseDeleteAllRowResult(const HbaseDeleteAllRowResult&);
  HbaseDeleteAllRowResult& operator=(const HbaseDeleteAllRowResult&);
  HbaseDeleteAllRowResult() {
  }

  virtual ~HbaseDeleteAllRowResult() throw();
  IOError Io;

  _Hbase_deleteAllRow_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDeleteAllRowResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllRowResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllRowResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllRowPresultIsset {
  HbaseDeleteAllRowPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllRow_presult__isset;

class HbaseDeleteAllRowPresult {
 public:


  virtual ~HbaseDeleteAllRowPresult() throw();
  IOError Io;

  _Hbase_deleteAllRow_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseIncrementArgsIsset {
  HbaseIncrementArgsIsset() : Increment(false) {}
  bool Increment :1;
} _Hbase_increment_args__isset;

class HbaseIncrementArgs {
 public:

  HbaseIncrementArgs(const HbaseIncrementArgs&);
  HbaseIncrementArgs& operator=(const HbaseIncrementArgs&);
  HbaseIncrementArgs() {
  }

  virtual ~HbaseIncrementArgs() throw();
  TIncrement Increment;

  _Hbase_increment_args__isset Isset;

  void SetIncrement(const TIncrement& val);

  bool operator == (const HbaseIncrementArgs & rhs) const
  {
    if (!(Increment == rhs.Increment))
      return false;
    return true;
  }
  bool operator != (const HbaseIncrementArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIncrementArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseIncrementPargs {
 public:


  virtual ~HbaseIncrementPargs() throw();
  const TIncrement* Increment;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIncrementResultIsset {
  HbaseIncrementResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_increment_result__isset;

class HbaseIncrementResult {
 public:

  HbaseIncrementResult(const HbaseIncrementResult&);
  HbaseIncrementResult& operator=(const HbaseIncrementResult&);
  HbaseIncrementResult() {
  }

  virtual ~HbaseIncrementResult() throw();
  IOError Io;

  _Hbase_increment_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseIncrementResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseIncrementResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIncrementResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIncrementPresultIsset {
  HbaseIncrementPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_increment_presult__isset;

class HbaseIncrementPresult {
 public:


  virtual ~HbaseIncrementPresult() throw();
  IOError Io;

  _Hbase_increment_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseIncrementRowsArgsIsset {
  HbaseIncrementRowsArgsIsset() : Increments(false) {}
  bool Increments :1;
} _Hbase_incrementRows_args__isset;

class HbaseIncrementRowsArgs {
 public:

  HbaseIncrementRowsArgs(const HbaseIncrementRowsArgs&);
  HbaseIncrementRowsArgs& operator=(const HbaseIncrementRowsArgs&);
  HbaseIncrementRowsArgs() {
  }

  virtual ~HbaseIncrementRowsArgs() throw();
  std::vector<TIncrement>  Increments;

  _Hbase_incrementRows_args__isset Isset;

  void SetIncrements(const std::vector<TIncrement> & val);

  bool operator == (const HbaseIncrementRowsArgs & rhs) const
  {
    if (!(Increments == rhs.Increments))
      return false;
    return true;
  }
  bool operator != (const HbaseIncrementRowsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIncrementRowsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseIncrementRowsPargs {
 public:


  virtual ~HbaseIncrementRowsPargs() throw();
  const std::vector<TIncrement> * Increments;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIncrementRowsResultIsset {
  HbaseIncrementRowsResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_incrementRows_result__isset;

class HbaseIncrementRowsResult {
 public:

  HbaseIncrementRowsResult(const HbaseIncrementRowsResult&);
  HbaseIncrementRowsResult& operator=(const HbaseIncrementRowsResult&);
  HbaseIncrementRowsResult() {
  }

  virtual ~HbaseIncrementRowsResult() throw();
  IOError Io;

  _Hbase_incrementRows_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseIncrementRowsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseIncrementRowsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseIncrementRowsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseIncrementRowsPresultIsset {
  HbaseIncrementRowsPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_incrementRows_presult__isset;

class HbaseIncrementRowsPresult {
 public:


  virtual ~HbaseIncrementRowsPresult() throw();
  IOError Io;

  _Hbase_incrementRows_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseDeleteAllRowTsArgsIsset {
  HbaseDeleteAllRowTsArgsIsset() : TableName(false), Row(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_deleteAllRowTs_args__isset;

class HbaseDeleteAllRowTsArgs {
 public:

  HbaseDeleteAllRowTsArgs(const HbaseDeleteAllRowTsArgs&);
  HbaseDeleteAllRowTsArgs& operator=(const HbaseDeleteAllRowTsArgs&);
  HbaseDeleteAllRowTsArgs() : TableName(), Row(), Timestamp(0) {
  }

  virtual ~HbaseDeleteAllRowTsArgs() throw();
  Text TableName;
  Text Row;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_deleteAllRowTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseDeleteAllRowTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllRowTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllRowTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseDeleteAllRowTsPargs {
 public:


  virtual ~HbaseDeleteAllRowTsPargs() throw();
  const Text* TableName;
  const Text* Row;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllRowTsResultIsset {
  HbaseDeleteAllRowTsResultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllRowTs_result__isset;

class HbaseDeleteAllRowTsResult {
 public:

  HbaseDeleteAllRowTsResult(const HbaseDeleteAllRowTsResult&);
  HbaseDeleteAllRowTsResult& operator=(const HbaseDeleteAllRowTsResult&);
  HbaseDeleteAllRowTsResult() {
  }

  virtual ~HbaseDeleteAllRowTsResult() throw();
  IOError Io;

  _Hbase_deleteAllRowTs_result__isset Isset;

  void SetIo(const IOError& val);

  bool operator == (const HbaseDeleteAllRowTsResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseDeleteAllRowTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseDeleteAllRowTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseDeleteAllRowTsPresultIsset {
  HbaseDeleteAllRowTsPresultIsset() : Io(false) {}
  bool Io :1;
} _Hbase_deleteAllRowTs_presult__isset;

class HbaseDeleteAllRowTsPresult {
 public:


  virtual ~HbaseDeleteAllRowTsPresult() throw();
  IOError Io;

  _Hbase_deleteAllRowTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenWithScanArgsIsset {
  HbaseScannerOpenWithScanArgsIsset() : TableName(false), Scan(false), Attributes(false) {}
  bool TableName :1;
  bool Scan :1;
  bool Attributes :1;
} _Hbase_scannerOpenWithScan_args__isset;

class HbaseScannerOpenWithScanArgs {
 public:

  HbaseScannerOpenWithScanArgs(const HbaseScannerOpenWithScanArgs&);
  HbaseScannerOpenWithScanArgs& operator=(const HbaseScannerOpenWithScanArgs&);
  HbaseScannerOpenWithScanArgs() : TableName() {
  }

  virtual ~HbaseScannerOpenWithScanArgs() throw();
  Text TableName;
  TScan Scan;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpenWithScan_args__isset Isset;

  void SetTableName(const Text& val);

  void SetScan(const TScan& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenWithScanArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Scan == rhs.Scan))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithScanArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithScanArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenWithScanPargs {
 public:


  virtual ~HbaseScannerOpenWithScanPargs() throw();
  const Text* TableName;
  const TScan* Scan;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithScanResultIsset {
  HbaseScannerOpenWithScanResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithScan_result__isset;

class HbaseScannerOpenWithScanResult {
 public:

  HbaseScannerOpenWithScanResult(const HbaseScannerOpenWithScanResult&);
  HbaseScannerOpenWithScanResult& operator=(const HbaseScannerOpenWithScanResult&);
  HbaseScannerOpenWithScanResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenWithScanResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpenWithScan_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenWithScanResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithScanResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithScanResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithScanPresultIsset {
  HbaseScannerOpenWithScanPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithScan_presult__isset;

class HbaseScannerOpenWithScanPresult {
 public:


  virtual ~HbaseScannerOpenWithScanPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpenWithScan_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenArgsIsset {
  HbaseScannerOpenArgsIsset() : TableName(false), StartRow(false), Columns(false), Attributes(false) {}
  bool TableName :1;
  bool StartRow :1;
  bool Columns :1;
  bool Attributes :1;
} _Hbase_scannerOpen_args__isset;

class HbaseScannerOpenArgs {
 public:

  HbaseScannerOpenArgs(const HbaseScannerOpenArgs&);
  HbaseScannerOpenArgs& operator=(const HbaseScannerOpenArgs&);
  HbaseScannerOpenArgs() : TableName(), StartRow() {
  }

  virtual ~HbaseScannerOpenArgs() throw();
  Text TableName;
  Text StartRow;
  std::vector<Text>  Columns;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpen_args__isset Isset;

  void SetTableName(const Text& val);

  void SetStartRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(StartRow == rhs.StartRow))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenPargs {
 public:


  virtual ~HbaseScannerOpenPargs() throw();
  const Text* TableName;
  const Text* StartRow;
  const std::vector<Text> * Columns;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenResultIsset {
  HbaseScannerOpenResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpen_result__isset;

class HbaseScannerOpenResult {
 public:

  HbaseScannerOpenResult(const HbaseScannerOpenResult&);
  HbaseScannerOpenResult& operator=(const HbaseScannerOpenResult&);
  HbaseScannerOpenResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpen_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenPresultIsset {
  HbaseScannerOpenPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpen_presult__isset;

class HbaseScannerOpenPresult {
 public:


  virtual ~HbaseScannerOpenPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpen_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenWithStopArgsIsset {
  HbaseScannerOpenWithStopArgsIsset() : TableName(false), StartRow(false), StopRow(false), Columns(false), Attributes(false) {}
  bool TableName :1;
  bool StartRow :1;
  bool StopRow :1;
  bool Columns :1;
  bool Attributes :1;
} _Hbase_scannerOpenWithStop_args__isset;

class HbaseScannerOpenWithStopArgs {
 public:

  HbaseScannerOpenWithStopArgs(const HbaseScannerOpenWithStopArgs&);
  HbaseScannerOpenWithStopArgs& operator=(const HbaseScannerOpenWithStopArgs&);
  HbaseScannerOpenWithStopArgs() : TableName(), StartRow(), StopRow() {
  }

  virtual ~HbaseScannerOpenWithStopArgs() throw();
  Text TableName;
  Text StartRow;
  Text StopRow;
  std::vector<Text>  Columns;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpenWithStop_args__isset Isset;

  void SetTableName(const Text& val);

  void SetStartRow(const Text& val);

  void SetStopRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenWithStopArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(StartRow == rhs.StartRow))
      return false;
    if (!(StopRow == rhs.StopRow))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithStopArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithStopArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenWithStopPargs {
 public:


  virtual ~HbaseScannerOpenWithStopPargs() throw();
  const Text* TableName;
  const Text* StartRow;
  const Text* StopRow;
  const std::vector<Text> * Columns;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithStopResultIsset {
  HbaseScannerOpenWithStopResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithStop_result__isset;

class HbaseScannerOpenWithStopResult {
 public:

  HbaseScannerOpenWithStopResult(const HbaseScannerOpenWithStopResult&);
  HbaseScannerOpenWithStopResult& operator=(const HbaseScannerOpenWithStopResult&);
  HbaseScannerOpenWithStopResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenWithStopResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpenWithStop_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenWithStopResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithStopResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithStopResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithStopPresultIsset {
  HbaseScannerOpenWithStopPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithStop_presult__isset;

class HbaseScannerOpenWithStopPresult {
 public:


  virtual ~HbaseScannerOpenWithStopPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpenWithStop_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenWithPrefixArgsIsset {
  HbaseScannerOpenWithPrefixArgsIsset() : TableName(false), StartAndPrefix(false), Columns(false), Attributes(false) {}
  bool TableName :1;
  bool StartAndPrefix :1;
  bool Columns :1;
  bool Attributes :1;
} _Hbase_scannerOpenWithPrefix_args__isset;

class HbaseScannerOpenWithPrefixArgs {
 public:

  HbaseScannerOpenWithPrefixArgs(const HbaseScannerOpenWithPrefixArgs&);
  HbaseScannerOpenWithPrefixArgs& operator=(const HbaseScannerOpenWithPrefixArgs&);
  HbaseScannerOpenWithPrefixArgs() : TableName(), StartAndPrefix() {
  }

  virtual ~HbaseScannerOpenWithPrefixArgs() throw();
  Text TableName;
  Text StartAndPrefix;
  std::vector<Text>  Columns;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpenWithPrefix_args__isset Isset;

  void SetTableName(const Text& val);

  void SetStartAndPrefix(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenWithPrefixArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(StartAndPrefix == rhs.StartAndPrefix))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithPrefixArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithPrefixArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenWithPrefixPargs {
 public:


  virtual ~HbaseScannerOpenWithPrefixPargs() throw();
  const Text* TableName;
  const Text* StartAndPrefix;
  const std::vector<Text> * Columns;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithPrefixResultIsset {
  HbaseScannerOpenWithPrefixResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithPrefix_result__isset;

class HbaseScannerOpenWithPrefixResult {
 public:

  HbaseScannerOpenWithPrefixResult(const HbaseScannerOpenWithPrefixResult&);
  HbaseScannerOpenWithPrefixResult& operator=(const HbaseScannerOpenWithPrefixResult&);
  HbaseScannerOpenWithPrefixResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenWithPrefixResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpenWithPrefix_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenWithPrefixResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithPrefixResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithPrefixResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithPrefixPresultIsset {
  HbaseScannerOpenWithPrefixPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithPrefix_presult__isset;

class HbaseScannerOpenWithPrefixPresult {
 public:


  virtual ~HbaseScannerOpenWithPrefixPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpenWithPrefix_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenTsArgsIsset {
  HbaseScannerOpenTsArgsIsset() : TableName(false), StartRow(false), Columns(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool StartRow :1;
  bool Columns :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_scannerOpenTs_args__isset;

class HbaseScannerOpenTsArgs {
 public:

  HbaseScannerOpenTsArgs(const HbaseScannerOpenTsArgs&);
  HbaseScannerOpenTsArgs& operator=(const HbaseScannerOpenTsArgs&);
  HbaseScannerOpenTsArgs() : TableName(), StartRow(), Timestamp(0) {
  }

  virtual ~HbaseScannerOpenTsArgs() throw();
  Text TableName;
  Text StartRow;
  std::vector<Text>  Columns;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpenTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetStartRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(StartRow == rhs.StartRow))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenTsPargs {
 public:


  virtual ~HbaseScannerOpenTsPargs() throw();
  const Text* TableName;
  const Text* StartRow;
  const std::vector<Text> * Columns;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenTsResultIsset {
  HbaseScannerOpenTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenTs_result__isset;

class HbaseScannerOpenTsResult {
 public:

  HbaseScannerOpenTsResult(const HbaseScannerOpenTsResult&);
  HbaseScannerOpenTsResult& operator=(const HbaseScannerOpenTsResult&);
  HbaseScannerOpenTsResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenTsResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpenTs_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenTsPresultIsset {
  HbaseScannerOpenTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenTs_presult__isset;

class HbaseScannerOpenTsPresult {
 public:


  virtual ~HbaseScannerOpenTsPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpenTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerOpenWithStopTsArgsIsset {
  HbaseScannerOpenWithStopTsArgsIsset() : TableName(false), StartRow(false), StopRow(false), Columns(false), Timestamp(false), Attributes(false) {}
  bool TableName :1;
  bool StartRow :1;
  bool StopRow :1;
  bool Columns :1;
  bool Timestamp :1;
  bool Attributes :1;
} _Hbase_scannerOpenWithStopTs_args__isset;

class HbaseScannerOpenWithStopTsArgs {
 public:

  HbaseScannerOpenWithStopTsArgs(const HbaseScannerOpenWithStopTsArgs&);
  HbaseScannerOpenWithStopTsArgs& operator=(const HbaseScannerOpenWithStopTsArgs&);
  HbaseScannerOpenWithStopTsArgs() : TableName(), StartRow(), StopRow(), Timestamp(0) {
  }

  virtual ~HbaseScannerOpenWithStopTsArgs() throw();
  Text TableName;
  Text StartRow;
  Text StopRow;
  std::vector<Text>  Columns;
  int64_t Timestamp;
  std::map<Text, Text>  Attributes;

  _Hbase_scannerOpenWithStopTs_args__isset Isset;

  void SetTableName(const Text& val);

  void SetStartRow(const Text& val);

  void SetStopRow(const Text& val);

  void SetColumns(const std::vector<Text> & val);

  void SetTimestamp(const int64_t val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseScannerOpenWithStopTsArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(StartRow == rhs.StartRow))
      return false;
    if (!(StopRow == rhs.StopRow))
      return false;
    if (!(Columns == rhs.Columns))
      return false;
    if (!(Timestamp == rhs.Timestamp))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithStopTsArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithStopTsArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerOpenWithStopTsPargs {
 public:


  virtual ~HbaseScannerOpenWithStopTsPargs() throw();
  const Text* TableName;
  const Text* StartRow;
  const Text* StopRow;
  const std::vector<Text> * Columns;
  const int64_t* Timestamp;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithStopTsResultIsset {
  HbaseScannerOpenWithStopTsResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithStopTs_result__isset;

class HbaseScannerOpenWithStopTsResult {
 public:

  HbaseScannerOpenWithStopTsResult(const HbaseScannerOpenWithStopTsResult&);
  HbaseScannerOpenWithStopTsResult& operator=(const HbaseScannerOpenWithStopTsResult&);
  HbaseScannerOpenWithStopTsResult() : Success(0) {
  }

  virtual ~HbaseScannerOpenWithStopTsResult() throw();
  ScannerID Success;
  IOError Io;

  _Hbase_scannerOpenWithStopTs_result__isset Isset;

  void SetSuccess(const ScannerID val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseScannerOpenWithStopTsResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerOpenWithStopTsResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerOpenWithStopTsResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerOpenWithStopTsPresultIsset {
  HbaseScannerOpenWithStopTsPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_scannerOpenWithStopTs_presult__isset;

class HbaseScannerOpenWithStopTsPresult {
 public:


  virtual ~HbaseScannerOpenWithStopTsPresult() throw();
  ScannerID* Success;
  IOError Io;

  _Hbase_scannerOpenWithStopTs_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerGetArgsIsset {
  HbaseScannerGetArgsIsset() : Id(false) {}
  bool Id :1;
} _Hbase_scannerGet_args__isset;

class HbaseScannerGetArgs {
 public:

  HbaseScannerGetArgs(const HbaseScannerGetArgs&);
  HbaseScannerGetArgs& operator=(const HbaseScannerGetArgs&);
  HbaseScannerGetArgs() : Id(0) {
  }

  virtual ~HbaseScannerGetArgs() throw();
  ScannerID Id;

  _Hbase_scannerGet_args__isset Isset;

  void SetId(const ScannerID val);

  bool operator == (const HbaseScannerGetArgs & rhs) const
  {
    if (!(Id == rhs.Id))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerGetArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerGetArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerGetPargs {
 public:


  virtual ~HbaseScannerGetPargs() throw();
  const ScannerID* Id;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerGetResultIsset {
  HbaseScannerGetResultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerGet_result__isset;

class HbaseScannerGetResult {
 public:

  HbaseScannerGetResult(const HbaseScannerGetResult&);
  HbaseScannerGetResult& operator=(const HbaseScannerGetResult&);
  HbaseScannerGetResult() {
  }

  virtual ~HbaseScannerGetResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerGet_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseScannerGetResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerGetResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerGetResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerGetPresultIsset {
  HbaseScannerGetPresultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerGet_presult__isset;

class HbaseScannerGetPresult {
 public:


  virtual ~HbaseScannerGetPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerGet_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerGetListArgsIsset {
  HbaseScannerGetListArgsIsset() : Id(false), NbRows(false) {}
  bool Id :1;
  bool NbRows :1;
} _Hbase_scannerGetList_args__isset;

class HbaseScannerGetListArgs {
 public:

  HbaseScannerGetListArgs(const HbaseScannerGetListArgs&);
  HbaseScannerGetListArgs& operator=(const HbaseScannerGetListArgs&);
  HbaseScannerGetListArgs() : Id(0), NbRows(0) {
  }

  virtual ~HbaseScannerGetListArgs() throw();
  ScannerID Id;
  int32_t NbRows;

  _Hbase_scannerGetList_args__isset Isset;

  void SetId(const ScannerID val);

  void SetNbRows(const int32_t val);

  bool operator == (const HbaseScannerGetListArgs & rhs) const
  {
    if (!(Id == rhs.Id))
      return false;
    if (!(NbRows == rhs.NbRows))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerGetListArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerGetListArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerGetListPargs {
 public:


  virtual ~HbaseScannerGetListPargs() throw();
  const ScannerID* Id;
  const int32_t* NbRows;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerGetListResultIsset {
  HbaseScannerGetListResultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerGetList_result__isset;

class HbaseScannerGetListResult {
 public:

  HbaseScannerGetListResult(const HbaseScannerGetListResult&);
  HbaseScannerGetListResult& operator=(const HbaseScannerGetListResult&);
  HbaseScannerGetListResult() {
  }

  virtual ~HbaseScannerGetListResult() throw();
  std::vector<TRowResult>  Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerGetList_result__isset Isset;

  void SetSuccess(const std::vector<TRowResult> & val);

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseScannerGetListResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerGetListResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerGetListResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerGetListPresultIsset {
  HbaseScannerGetListPresultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerGetList_presult__isset;

class HbaseScannerGetListPresult {
 public:


  virtual ~HbaseScannerGetListPresult() throw();
  std::vector<TRowResult> * Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerGetList_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseScannerCloseArgsIsset {
  HbaseScannerCloseArgsIsset() : Id(false) {}
  bool Id :1;
} _Hbase_scannerClose_args__isset;

class HbaseScannerCloseArgs {
 public:

  HbaseScannerCloseArgs(const HbaseScannerCloseArgs&);
  HbaseScannerCloseArgs& operator=(const HbaseScannerCloseArgs&);
  HbaseScannerCloseArgs() : Id(0) {
  }

  virtual ~HbaseScannerCloseArgs() throw();
  ScannerID Id;

  _Hbase_scannerClose_args__isset Isset;

  void SetId(const ScannerID val);

  bool operator == (const HbaseScannerCloseArgs & rhs) const
  {
    if (!(Id == rhs.Id))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerCloseArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerCloseArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseScannerClosePargs {
 public:


  virtual ~HbaseScannerClosePargs() throw();
  const ScannerID* Id;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerCloseResultIsset {
  HbaseScannerCloseResultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerClose_result__isset;

class HbaseScannerCloseResult {
 public:

  HbaseScannerCloseResult(const HbaseScannerCloseResult&);
  HbaseScannerCloseResult& operator=(const HbaseScannerCloseResult&);
  HbaseScannerCloseResult() {
  }

  virtual ~HbaseScannerCloseResult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerClose_result__isset Isset;

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseScannerCloseResult & rhs) const
  {
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseScannerCloseResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseScannerCloseResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseScannerClosePresultIsset {
  HbaseScannerClosePresultIsset() : Io(false), Ia(false) {}
  bool Io :1;
  bool Ia :1;
} _Hbase_scannerClose_presult__isset;

class HbaseScannerClosePresult {
 public:


  virtual ~HbaseScannerClosePresult() throw();
  IOError Io;
  IllegalArgument Ia;

  _Hbase_scannerClose_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRowOrBeforeArgsIsset {
  HbaseGetRowOrBeforeArgsIsset() : TableName(false), Row(false), Family(false) {}
  bool TableName :1;
  bool Row :1;
  bool Family :1;
} _Hbase_getRowOrBefore_args__isset;

class HbaseGetRowOrBeforeArgs {
 public:

  HbaseGetRowOrBeforeArgs(const HbaseGetRowOrBeforeArgs&);
  HbaseGetRowOrBeforeArgs& operator=(const HbaseGetRowOrBeforeArgs&);
  HbaseGetRowOrBeforeArgs() : TableName(), Row(), Family() {
  }

  virtual ~HbaseGetRowOrBeforeArgs() throw();
  Text TableName;
  Text Row;
  Text Family;

  _Hbase_getRowOrBefore_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetFamily(const Text& val);

  bool operator == (const HbaseGetRowOrBeforeArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Family == rhs.Family))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowOrBeforeArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowOrBeforeArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRowOrBeforePargs {
 public:


  virtual ~HbaseGetRowOrBeforePargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Family;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowOrBeforeResultIsset {
  HbaseGetRowOrBeforeResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowOrBefore_result__isset;

class HbaseGetRowOrBeforeResult {
 public:

  HbaseGetRowOrBeforeResult(const HbaseGetRowOrBeforeResult&);
  HbaseGetRowOrBeforeResult& operator=(const HbaseGetRowOrBeforeResult&);
  HbaseGetRowOrBeforeResult() {
  }

  virtual ~HbaseGetRowOrBeforeResult() throw();
  std::vector<TCell>  Success;
  IOError Io;

  _Hbase_getRowOrBefore_result__isset Isset;

  void SetSuccess(const std::vector<TCell> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRowOrBeforeResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRowOrBeforeResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRowOrBeforeResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRowOrBeforePresultIsset {
  HbaseGetRowOrBeforePresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRowOrBefore_presult__isset;

class HbaseGetRowOrBeforePresult {
 public:


  virtual ~HbaseGetRowOrBeforePresult() throw();
  std::vector<TCell> * Success;
  IOError Io;

  _Hbase_getRowOrBefore_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseGetRegionInfoArgsIsset {
  HbaseGetRegionInfoArgsIsset() : Row(false) {}
  bool Row :1;
} _Hbase_getRegionInfo_args__isset;

class HbaseGetRegionInfoArgs {
 public:

  HbaseGetRegionInfoArgs(const HbaseGetRegionInfoArgs&);
  HbaseGetRegionInfoArgs& operator=(const HbaseGetRegionInfoArgs&);
  HbaseGetRegionInfoArgs() : Row() {
  }

  virtual ~HbaseGetRegionInfoArgs() throw();
  Text Row;

  _Hbase_getRegionInfo_args__isset Isset;

  void SetRow(const Text& val);

  bool operator == (const HbaseGetRegionInfoArgs & rhs) const
  {
    if (!(Row == rhs.Row))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRegionInfoArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRegionInfoArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseGetRegionInfoPargs {
 public:


  virtual ~HbaseGetRegionInfoPargs() throw();
  const Text* Row;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRegionInfoResultIsset {
  HbaseGetRegionInfoResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRegionInfo_result__isset;

class HbaseGetRegionInfoResult {
 public:

  HbaseGetRegionInfoResult(const HbaseGetRegionInfoResult&);
  HbaseGetRegionInfoResult& operator=(const HbaseGetRegionInfoResult&);
  HbaseGetRegionInfoResult() {
  }

  virtual ~HbaseGetRegionInfoResult() throw();
  TRegionInfo Success;
  IOError Io;

  _Hbase_getRegionInfo_result__isset Isset;

  void SetSuccess(const TRegionInfo& val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseGetRegionInfoResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseGetRegionInfoResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseGetRegionInfoResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseGetRegionInfoPresultIsset {
  HbaseGetRegionInfoPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_getRegionInfo_presult__isset;

class HbaseGetRegionInfoPresult {
 public:


  virtual ~HbaseGetRegionInfoPresult() throw();
  TRegionInfo* Success;
  IOError Io;

  _Hbase_getRegionInfo_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseAppendArgsIsset {
  HbaseAppendArgsIsset() : Append(false) {}
  bool Append :1;
} _Hbase_append_args__isset;

class HbaseAppendArgs {
 public:

  HbaseAppendArgs(const HbaseAppendArgs&);
  HbaseAppendArgs& operator=(const HbaseAppendArgs&);
  HbaseAppendArgs() {
  }

  virtual ~HbaseAppendArgs() throw();
  TAppend Append;

  _Hbase_append_args__isset Isset;

  void SetAppend(const TAppend& val);

  bool operator == (const HbaseAppendArgs & rhs) const
  {
    if (!(Append == rhs.Append))
      return false;
    return true;
  }
  bool operator != (const HbaseAppendArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseAppendArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseAppendPargs {
 public:


  virtual ~HbaseAppendPargs() throw();
  const TAppend* Append;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseAppendResultIsset {
  HbaseAppendResultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_append_result__isset;

class HbaseAppendResult {
 public:

  HbaseAppendResult(const HbaseAppendResult&);
  HbaseAppendResult& operator=(const HbaseAppendResult&);
  HbaseAppendResult() {
  }

  virtual ~HbaseAppendResult() throw();
  std::vector<TCell>  Success;
  IOError Io;

  _Hbase_append_result__isset Isset;

  void SetSuccess(const std::vector<TCell> & val);

  void SetIo(const IOError& val);

  bool operator == (const HbaseAppendResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    return true;
  }
  bool operator != (const HbaseAppendResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseAppendResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseAppendPresultIsset {
  HbaseAppendPresultIsset() : Success(false), Io(false) {}
  bool Success :1;
  bool Io :1;
} _Hbase_append_presult__isset;

class HbaseAppendPresult {
 public:


  virtual ~HbaseAppendPresult() throw();
  std::vector<TCell> * Success;
  IOError Io;

  _Hbase_append_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

typedef struct HbaseCheckAndPutArgsIsset {
  HbaseCheckAndPutArgsIsset() : TableName(false), Row(false), Column(false), Value(false), Mput(false), Attributes(false) {}
  bool TableName :1;
  bool Row :1;
  bool Column :1;
  bool Value :1;
  bool Mput :1;
  bool Attributes :1;
} _Hbase_checkAndPut_args__isset;

class HbaseCheckAndPutArgs {
 public:

  HbaseCheckAndPutArgs(const HbaseCheckAndPutArgs&);
  HbaseCheckAndPutArgs& operator=(const HbaseCheckAndPutArgs&);
  HbaseCheckAndPutArgs() : TableName(), Row(), Column(), Value() {
  }

  virtual ~HbaseCheckAndPutArgs() throw();
  Text TableName;
  Text Row;
  Text Column;
  Text Value;
  Mutation Mput;
  std::map<Text, Text>  Attributes;

  _Hbase_checkAndPut_args__isset Isset;

  void SetTableName(const Text& val);

  void SetRow(const Text& val);

  void SetColumn(const Text& val);

  void SetValue(const Text& val);

  void SetMput(const Mutation& val);

  void SetAttributes(const std::map<Text, Text> & val);

  bool operator == (const HbaseCheckAndPutArgs & rhs) const
  {
    if (!(TableName == rhs.TableName))
      return false;
    if (!(Row == rhs.Row))
      return false;
    if (!(Column == rhs.Column))
      return false;
    if (!(Value == rhs.Value))
      return false;
    if (!(Mput == rhs.Mput))
      return false;
    if (!(Attributes == rhs.Attributes))
      return false;
    return true;
  }
  bool operator != (const HbaseCheckAndPutArgs &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCheckAndPutArgs & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};


class HbaseCheckAndPutPargs {
 public:


  virtual ~HbaseCheckAndPutPargs() throw();
  const Text* TableName;
  const Text* Row;
  const Text* Column;
  const Text* Value;
  const Mutation* Mput;
  const std::map<Text, Text> * Attributes;

  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCheckAndPutResultIsset {
  HbaseCheckAndPutResultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_checkAndPut_result__isset;

class HbaseCheckAndPutResult {
 public:

  HbaseCheckAndPutResult(const HbaseCheckAndPutResult&);
  HbaseCheckAndPutResult& operator=(const HbaseCheckAndPutResult&);
  HbaseCheckAndPutResult() : Success(0) {
  }

  virtual ~HbaseCheckAndPutResult() throw();
  bool Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_checkAndPut_result__isset Isset;

  void SetSuccess(const bool val);

  void SetIo(const IOError& val);

  void SetIa(const IllegalArgument& val);

  bool operator == (const HbaseCheckAndPutResult & rhs) const
  {
    if (!(Success == rhs.Success))
      return false;
    if (!(Io == rhs.Io))
      return false;
    if (!(Ia == rhs.Ia))
      return false;
    return true;
  }
  bool operator != (const HbaseCheckAndPutResult &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const HbaseCheckAndPutResult & ) const;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t Write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct HbaseCheckAndPutPresultIsset {
  HbaseCheckAndPutPresultIsset() : Success(false), Io(false), Ia(false) {}
  bool Success :1;
  bool Io :1;
  bool Ia :1;
} _Hbase_checkAndPut_presult__isset;

class HbaseCheckAndPutPresult {
 public:


  virtual ~HbaseCheckAndPutPresult() throw();
  bool* Success;
  IOError Io;
  IllegalArgument Ia;

  _Hbase_checkAndPut_presult__isset Isset;

  uint32_t Read(::apache::thrift::protocol::TProtocol* iprot);

};

class HbaseClient : virtual public HbaseIf {
 public:
  HbaseClient(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
    SetProtocol(prot);
  }
  HbaseClient(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    SetProtocol(iprot,oprot);
  }
 private:
  void SetProtocol(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
  SetProtocol(prot,prot);
  }
  void SetProtocol(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    Piprot_=iprot;
    Poprot_=oprot;
    Iprot_ = iprot.get();
    Oprot_ = oprot.get();
  }
 public:
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> GetInputProtocol() {
    return Piprot_;
  }
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> GetOutputProtocol() {
    return Poprot_;
  }
  void EnableTable(const Bytes& tableName);
  void SendEnableTable(const Bytes& tableName);
  void RecvEnableTable();
  void DisableTable(const Bytes& tableName);
  void SendDisableTable(const Bytes& tableName);
  void RecvDisableTable();
  bool IsTableEnabled(const Bytes& tableName);
  void SendIsTableEnabled(const Bytes& tableName);
  bool RecvIsTableEnabled();
  void Compact(const Bytes& tableNameOrRegionName);
  void SendCompact(const Bytes& tableNameOrRegionName);
  void RecvCompact();
  void MajorCompact(const Bytes& tableNameOrRegionName);
  void SendMajorCompact(const Bytes& tableNameOrRegionName);
  void RecvMajorCompact();
  void GetTableNames(std::vector<Text> & _return);
  void SendGetTableNames();
  void RecvGetTableNames(std::vector<Text> & _return);
  void GetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return, const Text& tableName);
  void SendGetColumnDescriptors(const Text& tableName);
  void RecvGetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return);
  void GetTableRegions(std::vector<TRegionInfo> & _return, const Text& tableName);
  void SendGetTableRegions(const Text& tableName);
  void RecvGetTableRegions(std::vector<TRegionInfo> & _return);
  void CreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies);
  void SendCreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies);
  void RecvCreateTable();
  void DeleteTable(const Text& tableName);
  void SendDeleteTable(const Text& tableName);
  void RecvDeleteTable();
  void Get(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void SendGet(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void RecvGet(std::vector<TCell> & _return);
  void GetVer(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void SendGetVer(const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void RecvGetVer(std::vector<TCell> & _return);
  void GetVerTs(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void SendGetVerTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void RecvGetVerTs(std::vector<TCell> & _return);
  void GetRow(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void SendGetRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void RecvGetRow(std::vector<TRowResult> & _return);
  void GetRowWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void SendGetRowWithColumns(const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void RecvGetRowWithColumns(std::vector<TRowResult> & _return);
  void GetRowTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendGetRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowTs(std::vector<TRowResult> & _return);
  void GetRowWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendGetRowWithColumnsTs(const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowWithColumnsTs(std::vector<TRowResult> & _return);
  void GetRows(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes);
  void SendGetRows(const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes);
  void RecvGetRows(std::vector<TRowResult> & _return);
  void GetRowsWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void SendGetRowsWithColumns(const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void RecvGetRowsWithColumns(std::vector<TRowResult> & _return);
  void GetRowsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendGetRowsTs(const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowsTs(std::vector<TRowResult> & _return);
  void GetRowsWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendGetRowsWithColumnsTs(const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowsWithColumnsTs(std::vector<TRowResult> & _return);
  void MutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes);
  void SendMutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes);
  void RecvMutateRow();
  void MutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendMutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvMutateRowTs();
  void MutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes);
  void SendMutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes);
  void RecvMutateRows();
  void MutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendMutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvMutateRowsTs();
  int64_t AtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value);
  void SendAtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value);
  int64_t RecvAtomicIncrement();
  void DeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void SendDeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void RecvDeleteAll();
  void DeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendDeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvDeleteAllTs();
  void DeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void SendDeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void RecvDeleteAllRow();
  void Increment(const TIncrement& increment);
  void SendIncrement(const TIncrement& increment);
  void RecvIncrement();
  void IncrementRows(const std::vector<TIncrement> & increments);
  void SendIncrementRows(const std::vector<TIncrement> & increments);
  void RecvIncrementRows();
  void DeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendDeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvDeleteAllRowTs();
  ScannerID ScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes);
  void SendScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithScan();
  ScannerID ScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void SendScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpen();
  ScannerID ScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void SendScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithStop();
  ScannerID ScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void SendScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithPrefix();
  ScannerID ScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenTs();
  ScannerID ScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void SendScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithStopTs();
  void ScannerGet(std::vector<TRowResult> & _return, const ScannerID id);
  void SendScannerGet(const ScannerID id);
  void RecvScannerGet(std::vector<TRowResult> & _return);
  void ScannerGetList(std::vector<TRowResult> & _return, const ScannerID id, const int32_t nbRows);
  void SendScannerGetList(const ScannerID id, const int32_t nbRows);
  void RecvScannerGetList(std::vector<TRowResult> & _return);
  void ScannerClose(const ScannerID id);
  void SendScannerClose(const ScannerID id);
  void RecvScannerClose();
  void GetRowOrBefore(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& family);
  void SendGetRowOrBefore(const Text& tableName, const Text& row, const Text& family);
  void RecvGetRowOrBefore(std::vector<TCell> & _return);
  void GetRegionInfo(TRegionInfo& _return, const Text& row);
  void SendGetRegionInfo(const Text& row);
  void RecvGetRegionInfo(TRegionInfo& _return);
  void Append(std::vector<TCell> & _return, const TAppend& append);
  void SendAppend(const TAppend& append);
  void RecvAppend(std::vector<TCell> & _return);
  bool CheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes);
  void SendCheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes);
  bool RecvCheckAndPut();
 protected:
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> Piprot_;
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> Poprot_;
  ::apache::thrift::protocol::TProtocol* Iprot_;
  ::apache::thrift::protocol::TProtocol* Oprot_;
};

class HbaseProcessor : public ::apache::thrift::TDispatchProcessor {
 protected:
  ::apache::thrift::stdcxx::shared_ptr<HbaseIf> Iface_;
  virtual bool dispatchCall(::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, const std::string& fname, int32_t seqid, void* callContext);
 private:
  typedef  void (HbaseProcessor::*ProcessFunction)(int32_t, ::apache::thrift::protocol::TProtocol*, ::apache::thrift::protocol::TProtocol*, void*);
  typedef std::map<std::string, ProcessFunction> ProcessMap;
  ProcessMap ProcessMap_;
  void ProcessEnableTable(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDisableTable(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessIsTableEnabled(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessCompact(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessMajorCompact(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetTableNames(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetColumnDescriptors(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetTableRegions(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessCreateTable(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDeleteTable(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGet(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetVer(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetVerTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRow(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowWithColumns(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowWithColumnsTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRows(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowsWithColumns(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowsTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowsWithColumnsTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessMutateRow(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessMutateRowTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessMutateRows(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessMutateRowsTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessAtomicIncrement(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDeleteAll(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDeleteAllTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDeleteAllRow(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessIncrement(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessIncrementRows(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessDeleteAllRowTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpenWithScan(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpen(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpenWithStop(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpenWithPrefix(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpenTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerOpenWithStopTs(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerGet(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerGetList(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessScannerClose(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRowOrBefore(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessGetRegionInfo(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessAppend(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
  void ProcessCheckAndPut(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, void* callContext);
 public:
  HbaseProcessor(::apache::thrift::stdcxx::shared_ptr<HbaseIf> iface) :
    Iface_(iface) {
    ProcessMap_["enableTable"] = &HbaseProcessor::ProcessEnableTable;
    ProcessMap_["disableTable"] = &HbaseProcessor::ProcessDisableTable;
    ProcessMap_["isTableEnabled"] = &HbaseProcessor::ProcessIsTableEnabled;
    ProcessMap_["compact"] = &HbaseProcessor::ProcessCompact;
    ProcessMap_["majorCompact"] = &HbaseProcessor::ProcessMajorCompact;
    ProcessMap_["getTableNames"] = &HbaseProcessor::ProcessGetTableNames;
    ProcessMap_["getColumnDescriptors"] = &HbaseProcessor::ProcessGetColumnDescriptors;
    ProcessMap_["getTableRegions"] = &HbaseProcessor::ProcessGetTableRegions;
    ProcessMap_["createTable"] = &HbaseProcessor::ProcessCreateTable;
    ProcessMap_["deleteTable"] = &HbaseProcessor::ProcessDeleteTable;
    ProcessMap_["get"] = &HbaseProcessor::ProcessGet;
    ProcessMap_["getVer"] = &HbaseProcessor::ProcessGetVer;
    ProcessMap_["getVerTs"] = &HbaseProcessor::ProcessGetVerTs;
    ProcessMap_["getRow"] = &HbaseProcessor::ProcessGetRow;
    ProcessMap_["getRowWithColumns"] = &HbaseProcessor::ProcessGetRowWithColumns;
    ProcessMap_["getRowTs"] = &HbaseProcessor::ProcessGetRowTs;
    ProcessMap_["getRowWithColumnsTs"] = &HbaseProcessor::ProcessGetRowWithColumnsTs;
    ProcessMap_["getRows"] = &HbaseProcessor::ProcessGetRows;
    ProcessMap_["getRowsWithColumns"] = &HbaseProcessor::ProcessGetRowsWithColumns;
    ProcessMap_["getRowsTs"] = &HbaseProcessor::ProcessGetRowsTs;
    ProcessMap_["getRowsWithColumnsTs"] = &HbaseProcessor::ProcessGetRowsWithColumnsTs;
    ProcessMap_["mutateRow"] = &HbaseProcessor::ProcessMutateRow;
    ProcessMap_["mutateRowTs"] = &HbaseProcessor::ProcessMutateRowTs;
    ProcessMap_["mutateRows"] = &HbaseProcessor::ProcessMutateRows;
    ProcessMap_["mutateRowsTs"] = &HbaseProcessor::ProcessMutateRowsTs;
    ProcessMap_["atomicIncrement"] = &HbaseProcessor::ProcessAtomicIncrement;
    ProcessMap_["deleteAll"] = &HbaseProcessor::ProcessDeleteAll;
    ProcessMap_["deleteAllTs"] = &HbaseProcessor::ProcessDeleteAllTs;
    ProcessMap_["deleteAllRow"] = &HbaseProcessor::ProcessDeleteAllRow;
    ProcessMap_["increment"] = &HbaseProcessor::ProcessIncrement;
    ProcessMap_["incrementRows"] = &HbaseProcessor::ProcessIncrementRows;
    ProcessMap_["deleteAllRowTs"] = &HbaseProcessor::ProcessDeleteAllRowTs;
    ProcessMap_["scannerOpenWithScan"] = &HbaseProcessor::ProcessScannerOpenWithScan;
    ProcessMap_["scannerOpen"] = &HbaseProcessor::ProcessScannerOpen;
    ProcessMap_["scannerOpenWithStop"] = &HbaseProcessor::ProcessScannerOpenWithStop;
    ProcessMap_["scannerOpenWithPrefix"] = &HbaseProcessor::ProcessScannerOpenWithPrefix;
    ProcessMap_["scannerOpenTs"] = &HbaseProcessor::ProcessScannerOpenTs;
    ProcessMap_["scannerOpenWithStopTs"] = &HbaseProcessor::ProcessScannerOpenWithStopTs;
    ProcessMap_["scannerGet"] = &HbaseProcessor::ProcessScannerGet;
    ProcessMap_["scannerGetList"] = &HbaseProcessor::ProcessScannerGetList;
    ProcessMap_["scannerClose"] = &HbaseProcessor::ProcessScannerClose;
    ProcessMap_["getRowOrBefore"] = &HbaseProcessor::ProcessGetRowOrBefore;
    ProcessMap_["getRegionInfo"] = &HbaseProcessor::ProcessGetRegionInfo;
    ProcessMap_["append"] = &HbaseProcessor::ProcessAppend;
    ProcessMap_["checkAndPut"] = &HbaseProcessor::ProcessCheckAndPut;
  }

  virtual ~HbaseProcessor() {}
};

class HbaseProcessorFactory : public ::apache::thrift::TProcessorFactory {
 public:
  HbaseProcessorFactory(const ::apache::thrift::stdcxx::shared_ptr< HbaseIfFactory >& handlerFactory) :
      HandlerFactory_(handlerFactory) {}

  ::apache::thrift::stdcxx::shared_ptr< ::apache::thrift::TProcessor > getProcessor(const ::apache::thrift::TConnectionInfo& connInfo);

 protected:
  ::apache::thrift::stdcxx::shared_ptr< HbaseIfFactory > HandlerFactory_;
};

class HbaseMultiface : virtual public HbaseIf {
 public:
  HbaseMultiface(std::vector<apache::thrift::stdcxx::shared_ptr<HbaseIf> >& ifaces) : Ifaces_(ifaces) {
  }
  virtual ~HbaseMultiface() {}
 protected:
  std::vector<apache::thrift::stdcxx::shared_ptr<HbaseIf> > Ifaces_;
  HbaseMultiface() {}
  void Add(::apache::thrift::stdcxx::shared_ptr<HbaseIf> iface) {
    Ifaces_.push_back(iface);
  }
 public:
  void EnableTable(const Bytes& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->EnableTable(tableName);
    }
    Ifaces_[i]->EnableTable(tableName);
  }

  void DisableTable(const Bytes& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DisableTable(tableName);
    }
    Ifaces_[i]->DisableTable(tableName);
  }

  bool IsTableEnabled(const Bytes& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->IsTableEnabled(tableName);
    }
    return Ifaces_[i]->IsTableEnabled(tableName);
  }

  void Compact(const Bytes& tableNameOrRegionName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->Compact(tableNameOrRegionName);
    }
    Ifaces_[i]->Compact(tableNameOrRegionName);
  }

  void MajorCompact(const Bytes& tableNameOrRegionName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->MajorCompact(tableNameOrRegionName);
    }
    Ifaces_[i]->MajorCompact(tableNameOrRegionName);
  }

  void GetTableNames(std::vector<Text> & _return) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetTableNames(_return);
    }
    Ifaces_[i]->GetTableNames(_return);
    return;
  }

  void GetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return, const Text& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetColumnDescriptors(_return, tableName);
    }
    Ifaces_[i]->GetColumnDescriptors(_return, tableName);
    return;
  }

  void GetTableRegions(std::vector<TRegionInfo> & _return, const Text& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetTableRegions(_return, tableName);
    }
    Ifaces_[i]->GetTableRegions(_return, tableName);
    return;
  }

  void CreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->CreateTable(tableName, columnFamilies);
    }
    Ifaces_[i]->CreateTable(tableName, columnFamilies);
  }

  void DeleteTable(const Text& tableName) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DeleteTable(tableName);
    }
    Ifaces_[i]->DeleteTable(tableName);
  }

  void Get(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->Get(_return, tableName, row, column, attributes);
    }
    Ifaces_[i]->Get(_return, tableName, row, column, attributes);
    return;
  }

  void GetVer(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetVer(_return, tableName, row, column, numVersions, attributes);
    }
    Ifaces_[i]->GetVer(_return, tableName, row, column, numVersions, attributes);
    return;
  }

  void GetVerTs(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetVerTs(_return, tableName, row, column, timestamp, numVersions, attributes);
    }
    Ifaces_[i]->GetVerTs(_return, tableName, row, column, timestamp, numVersions, attributes);
    return;
  }

  void GetRow(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRow(_return, tableName, row, attributes);
    }
    Ifaces_[i]->GetRow(_return, tableName, row, attributes);
    return;
  }

  void GetRowWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowWithColumns(_return, tableName, row, columns, attributes);
    }
    Ifaces_[i]->GetRowWithColumns(_return, tableName, row, columns, attributes);
    return;
  }

  void GetRowTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowTs(_return, tableName, row, timestamp, attributes);
    }
    Ifaces_[i]->GetRowTs(_return, tableName, row, timestamp, attributes);
    return;
  }

  void GetRowWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowWithColumnsTs(_return, tableName, row, columns, timestamp, attributes);
    }
    Ifaces_[i]->GetRowWithColumnsTs(_return, tableName, row, columns, timestamp, attributes);
    return;
  }

  void GetRows(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRows(_return, tableName, rows, attributes);
    }
    Ifaces_[i]->GetRows(_return, tableName, rows, attributes);
    return;
  }

  void GetRowsWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowsWithColumns(_return, tableName, rows, columns, attributes);
    }
    Ifaces_[i]->GetRowsWithColumns(_return, tableName, rows, columns, attributes);
    return;
  }

  void GetRowsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowsTs(_return, tableName, rows, timestamp, attributes);
    }
    Ifaces_[i]->GetRowsTs(_return, tableName, rows, timestamp, attributes);
    return;
  }

  void GetRowsWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowsWithColumnsTs(_return, tableName, rows, columns, timestamp, attributes);
    }
    Ifaces_[i]->GetRowsWithColumnsTs(_return, tableName, rows, columns, timestamp, attributes);
    return;
  }

  void MutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->MutateRow(tableName, row, mutations, attributes);
    }
    Ifaces_[i]->MutateRow(tableName, row, mutations, attributes);
  }

  void MutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->MutateRowTs(tableName, row, mutations, timestamp, attributes);
    }
    Ifaces_[i]->MutateRowTs(tableName, row, mutations, timestamp, attributes);
  }

  void MutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->MutateRows(tableName, rowBatches, attributes);
    }
    Ifaces_[i]->MutateRows(tableName, rowBatches, attributes);
  }

  void MutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->MutateRowsTs(tableName, rowBatches, timestamp, attributes);
    }
    Ifaces_[i]->MutateRowsTs(tableName, rowBatches, timestamp, attributes);
  }

  int64_t AtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->AtomicIncrement(tableName, row, column, value);
    }
    return Ifaces_[i]->AtomicIncrement(tableName, row, column, value);
  }

  void DeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DeleteAll(tableName, row, column, attributes);
    }
    Ifaces_[i]->DeleteAll(tableName, row, column, attributes);
  }

  void DeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DeleteAllTs(tableName, row, column, timestamp, attributes);
    }
    Ifaces_[i]->DeleteAllTs(tableName, row, column, timestamp, attributes);
  }

  void DeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DeleteAllRow(tableName, row, attributes);
    }
    Ifaces_[i]->DeleteAllRow(tableName, row, attributes);
  }

  void Increment(const TIncrement& increment) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->Increment(increment);
    }
    Ifaces_[i]->Increment(increment);
  }

  void IncrementRows(const std::vector<TIncrement> & increments) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->IncrementRows(increments);
    }
    Ifaces_[i]->IncrementRows(increments);
  }

  void DeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->DeleteAllRowTs(tableName, row, timestamp, attributes);
    }
    Ifaces_[i]->DeleteAllRowTs(tableName, row, timestamp, attributes);
  }

  ScannerID ScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpenWithScan(tableName, scan, attributes);
    }
    return Ifaces_[i]->ScannerOpenWithScan(tableName, scan, attributes);
  }

  ScannerID ScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpen(tableName, startRow, columns, attributes);
    }
    return Ifaces_[i]->ScannerOpen(tableName, startRow, columns, attributes);
  }

  ScannerID ScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpenWithStop(tableName, startRow, stopRow, columns, attributes);
    }
    return Ifaces_[i]->ScannerOpenWithStop(tableName, startRow, stopRow, columns, attributes);
  }

  ScannerID ScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes);
    }
    return Ifaces_[i]->ScannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes);
  }

  ScannerID ScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpenTs(tableName, startRow, columns, timestamp, attributes);
    }
    return Ifaces_[i]->ScannerOpenTs(tableName, startRow, columns, timestamp, attributes);
  }

  ScannerID ScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes);
    }
    return Ifaces_[i]->ScannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes);
  }

  void ScannerGet(std::vector<TRowResult> & _return, const ScannerID id) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerGet(_return, id);
    }
    Ifaces_[i]->ScannerGet(_return, id);
    return;
  }

  void ScannerGetList(std::vector<TRowResult> & _return, const ScannerID id, const int32_t nbRows) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerGetList(_return, id, nbRows);
    }
    Ifaces_[i]->ScannerGetList(_return, id, nbRows);
    return;
  }

  void ScannerClose(const ScannerID id) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->ScannerClose(id);
    }
    Ifaces_[i]->ScannerClose(id);
  }

  void GetRowOrBefore(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& family) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRowOrBefore(_return, tableName, row, family);
    }
    Ifaces_[i]->GetRowOrBefore(_return, tableName, row, family);
    return;
  }

  void GetRegionInfo(TRegionInfo& _return, const Text& row) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->GetRegionInfo(_return, row);
    }
    Ifaces_[i]->GetRegionInfo(_return, row);
    return;
  }

  void Append(std::vector<TCell> & _return, const TAppend& append) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->Append(_return, append);
    }
    Ifaces_[i]->Append(_return, append);
    return;
  }

  bool CheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes) {
    size_t sz = Ifaces_.size();
    size_t i = 0;
    for (; i < (sz - 1); ++i) {
      Ifaces_[i]->CheckAndPut(tableName, row, column, value, mput, attributes);
    }
    return Ifaces_[i]->CheckAndPut(tableName, row, column, value, mput, attributes);
  }

};

// The 'concurrent' client is a thread safe client that correctly handles
// out of order responses.  It is slower than the regular client, so should
// only be used when you need to share a connection among multiple threads
class HbaseConcurrentClient : virtual public HbaseIf {
 public:
  HbaseConcurrentClient(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
    SetProtocol(prot);
  }
  HbaseConcurrentClient(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    SetProtocol(iprot,oprot);
  }
 private:
  void SetProtocol(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) {
  SetProtocol(prot,prot);
  }
  void SetProtocol(apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) {
    Piprot_=iprot;
    Poprot_=oprot;
    Iprot_ = iprot.get();
    Oprot_ = oprot.get();
  }
 public:
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> GetInputProtocol() {
    return Piprot_;
  }
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> GetOutputProtocol() {
    return Poprot_;
  }
  void EnableTable(const Bytes& tableName);
  int32_t SendEnableTable(const Bytes& tableName);
  void RecvEnableTable(const int32_t seqid);
  void DisableTable(const Bytes& tableName);
  int32_t SendDisableTable(const Bytes& tableName);
  void RecvDisableTable(const int32_t seqid);
  bool IsTableEnabled(const Bytes& tableName);
  int32_t SendIsTableEnabled(const Bytes& tableName);
  bool RecvIsTableEnabled(const int32_t seqid);
  void Compact(const Bytes& tableNameOrRegionName);
  int32_t SendCompact(const Bytes& tableNameOrRegionName);
  void RecvCompact(const int32_t seqid);
  void MajorCompact(const Bytes& tableNameOrRegionName);
  int32_t SendMajorCompact(const Bytes& tableNameOrRegionName);
  void RecvMajorCompact(const int32_t seqid);
  void GetTableNames(std::vector<Text> & _return);
  int32_t SendGetTableNames();
  void RecvGetTableNames(std::vector<Text> & _return, const int32_t seqid);
  void GetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return, const Text& tableName);
  int32_t SendGetColumnDescriptors(const Text& tableName);
  void RecvGetColumnDescriptors(std::map<Text, ColumnDescriptor> & _return, const int32_t seqid);
  void GetTableRegions(std::vector<TRegionInfo> & _return, const Text& tableName);
  int32_t SendGetTableRegions(const Text& tableName);
  void RecvGetTableRegions(std::vector<TRegionInfo> & _return, const int32_t seqid);
  void CreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies);
  int32_t SendCreateTable(const Text& tableName, const std::vector<ColumnDescriptor> & columnFamilies);
  void RecvCreateTable(const int32_t seqid);
  void DeleteTable(const Text& tableName);
  int32_t SendDeleteTable(const Text& tableName);
  void RecvDeleteTable(const int32_t seqid);
  void Get(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  int32_t SendGet(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void RecvGet(std::vector<TCell> & _return, const int32_t seqid);
  void GetVer(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes);
  int32_t SendGetVer(const Text& tableName, const Text& row, const Text& column, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void RecvGetVer(std::vector<TCell> & _return, const int32_t seqid);
  void GetVerTs(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes);
  int32_t SendGetVerTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const int32_t numVersions, const std::map<Text, Text> & attributes);
  void RecvGetVerTs(std::vector<TCell> & _return, const int32_t seqid);
  void GetRow(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  int32_t SendGetRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void RecvGetRow(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  int32_t SendGetRowWithColumns(const Text& tableName, const Text& row, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void RecvGetRowWithColumns(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendGetRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowTs(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendGetRowWithColumnsTs(const Text& tableName, const Text& row, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowWithColumnsTs(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRows(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes);
  int32_t SendGetRows(const Text& tableName, const std::vector<Text> & rows, const std::map<Text, Text> & attributes);
  void RecvGetRows(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowsWithColumns(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  int32_t SendGetRowsWithColumns(const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  void RecvGetRowsWithColumns(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendGetRowsTs(const Text& tableName, const std::vector<Text> & rows, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowsTs(std::vector<TRowResult> & _return, const int32_t seqid);
  void GetRowsWithColumnsTs(std::vector<TRowResult> & _return, const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendGetRowsWithColumnsTs(const Text& tableName, const std::vector<Text> & rows, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvGetRowsWithColumnsTs(std::vector<TRowResult> & _return, const int32_t seqid);
  void MutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes);
  int32_t SendMutateRow(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const std::map<Text, Text> & attributes);
  void RecvMutateRow(const int32_t seqid);
  void MutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendMutateRowTs(const Text& tableName, const Text& row, const std::vector<Mutation> & mutations, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvMutateRowTs(const int32_t seqid);
  void MutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes);
  int32_t SendMutateRows(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const std::map<Text, Text> & attributes);
  void RecvMutateRows(const int32_t seqid);
  void MutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendMutateRowsTs(const Text& tableName, const std::vector<BatchMutation> & rowBatches, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvMutateRowsTs(const int32_t seqid);
  int64_t AtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value);
  int32_t SendAtomicIncrement(const Text& tableName, const Text& row, const Text& column, const int64_t value);
  int64_t RecvAtomicIncrement(const int32_t seqid);
  void DeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  int32_t SendDeleteAll(const Text& tableName, const Text& row, const Text& column, const std::map<Text, Text> & attributes);
  void RecvDeleteAll(const int32_t seqid);
  void DeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendDeleteAllTs(const Text& tableName, const Text& row, const Text& column, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvDeleteAllTs(const int32_t seqid);
  void DeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  int32_t SendDeleteAllRow(const Text& tableName, const Text& row, const std::map<Text, Text> & attributes);
  void RecvDeleteAllRow(const int32_t seqid);
  void Increment(const TIncrement& increment);
  int32_t SendIncrement(const TIncrement& increment);
  void RecvIncrement(const int32_t seqid);
  void IncrementRows(const std::vector<TIncrement> & increments);
  int32_t SendIncrementRows(const std::vector<TIncrement> & increments);
  void RecvIncrementRows(const int32_t seqid);
  void DeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendDeleteAllRowTs(const Text& tableName, const Text& row, const int64_t timestamp, const std::map<Text, Text> & attributes);
  void RecvDeleteAllRowTs(const int32_t seqid);
  ScannerID ScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpenWithScan(const Text& tableName, const TScan& scan, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithScan(const int32_t seqid);
  ScannerID ScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpen(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpen(const int32_t seqid);
  ScannerID ScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpenWithStop(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithStop(const int32_t seqid);
  ScannerID ScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpenWithPrefix(const Text& tableName, const Text& startAndPrefix, const std::vector<Text> & columns, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithPrefix(const int32_t seqid);
  ScannerID ScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpenTs(const Text& tableName, const Text& startRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenTs(const int32_t seqid);
  ScannerID ScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  int32_t SendScannerOpenWithStopTs(const Text& tableName, const Text& startRow, const Text& stopRow, const std::vector<Text> & columns, const int64_t timestamp, const std::map<Text, Text> & attributes);
  ScannerID RecvScannerOpenWithStopTs(const int32_t seqid);
  void ScannerGet(std::vector<TRowResult> & _return, const ScannerID id);
  int32_t SendScannerGet(const ScannerID id);
  void RecvScannerGet(std::vector<TRowResult> & _return, const int32_t seqid);
  void ScannerGetList(std::vector<TRowResult> & _return, const ScannerID id, const int32_t nbRows);
  int32_t SendScannerGetList(const ScannerID id, const int32_t nbRows);
  void RecvScannerGetList(std::vector<TRowResult> & _return, const int32_t seqid);
  void ScannerClose(const ScannerID id);
  int32_t SendScannerClose(const ScannerID id);
  void RecvScannerClose(const int32_t seqid);
  void GetRowOrBefore(std::vector<TCell> & _return, const Text& tableName, const Text& row, const Text& family);
  int32_t SendGetRowOrBefore(const Text& tableName, const Text& row, const Text& family);
  void RecvGetRowOrBefore(std::vector<TCell> & _return, const int32_t seqid);
  void GetRegionInfo(TRegionInfo& _return, const Text& row);
  int32_t SendGetRegionInfo(const Text& row);
  void RecvGetRegionInfo(TRegionInfo& _return, const int32_t seqid);
  void Append(std::vector<TCell> & _return, const TAppend& append);
  int32_t SendAppend(const TAppend& append);
  void RecvAppend(std::vector<TCell> & _return, const int32_t seqid);
  bool CheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes);
  int32_t SendCheckAndPut(const Text& tableName, const Text& row, const Text& column, const Text& value, const Mutation& mput, const std::map<Text, Text> & attributes);
  bool RecvCheckAndPut(const int32_t seqid);
 protected:
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> Piprot_;
  apache::thrift::stdcxx::shared_ptr< ::apache::thrift::protocol::TProtocol> Poprot_;
  ::apache::thrift::protocol::TProtocol* Iprot_;
  ::apache::thrift::protocol::TProtocol* Oprot_;
  ::apache::thrift::async::TConcurrentClientSyncInfo Sync_;
};

#ifdef _MSC_VER
  #pragma warning( pop )
#endif

}}}} // namespace
