#pragma once

#include "hbase_client.h"
#include "settings.h"

namespace NPassport::NHbase {
    class IHBasePool {
    public:
        virtual ~IHBasePool() = default;
        virtual TClientGuard GetClient() = 0;
    };

    // THREAD UNSAFE POOL
    class THBasePool: public IHBasePool {
    public:
        THBasePool(const TSettings& settings);

        TClientGuard GetClient() override;

    private:
        THBaseClient* TryGet(size_t idx);

    private:
        std::vector<std::unique_ptr<THBaseClient>> Instances_;
    };
}
