#include "query.h"

#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/stream/str.h>

namespace NPassport::NHbase {
    static bool IsPrintable(const TStringBuf buf) {
        return std::find_if_not(buf.begin(), buf.end(), [](char c) {
                   return isprint(c) > 0;
               }) == buf.end();
    }

    static std::string Print(const std::string& buf) {
        if (IsPrintable(buf)) {
            return buf;
        }

        return NUtils::CreateStr("<base64>:", NUtils::BinToBase64(buf));
    }

    TString TQuery::PrintDebug() const {
        TStringStream o;

        o << Endl;
        o << ".type_=NHbase::TQuery::EType::" << Type << "," << Endl;
        o << ".row_=\"" << Print(Row) << "\"," << Endl;
        o << ".params_={" << Endl;
        for (const auto& [column, value] : Params) {
            o << "{\"" << Print(column) << "\", \"" << Print(value) << "\"}," << Endl;
        }
        o << "}," << Endl;

        return o.Str();
    }

    void TQueries::Merge(TQueries&& o) {
        if (ByTable.empty()) {
            ByTable = std::move(o.ByTable);
            return;
        }

        for (auto& [table, queries] : o.ByTable) {
            TQueryArray& arr = ByTable.try_emplace(table, NHbase::TQueryArray()).first->second;
            if (arr.empty()) {
                arr = std::move(queries);
                continue;
            }

            arr.reserve(arr.size() + queries.size());
            for (NHbase::TQuery& q : queries) {
                arr.push_back(std::move(q));
            }
        }

        o.ByTable.clear();
    }
}
