#pragma once

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <map>
#include <string>

namespace NPassport::NHbase {
    class TStringWrapper: public std::string {
    public:
        TStringWrapper(std::string&& s)
            : std::string(std::move(s))
        {
        }

        TStringWrapper(const std::string& s)
            : std::string(s)
        {
        }

        TStringWrapper(TStringBuf s)
            : std::string(s)
        {
        }

    private:
        TStringWrapper(const TString&);
        TStringWrapper(TString&&);
    };

    struct TQuery: TMoveOnly {
        enum class EType {
            Put,
        };

        EType Type = EType::Put;
        TString Row;
        TStackVec<std::pair<std::string, std::string>, 24> Params;

        template <class Key, class Value>
        void AddParam(Key&& key, Value&& value) {
            if (!value.empty()) {
                Params.emplace_back(std::forward<TStringWrapper>(key),
                                    std::forward<TStringWrapper>(value));
            }
        }

        bool operator==(const TQuery& o) const {
            return Type == o.Type && Row == o.Row && Params == o.Params;
        }

        TString PrintDebug() const;
    };

    using TQueryArray = std::vector<TQuery>;

    struct TQueries {
        void Merge(TQueries&& o);

        // table name -> queries
        std::map<std::string, TQueryArray> ByTable;
    };
}
