#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NHbase {
    struct TSettings {
        struct THost {
            TString Host;
            ui16 Port;
        };

        std::vector<THost> Hosts;
        TDuration MinReopenPeriod = TDuration::Seconds(5);
        TDuration ConnectTimeout = TDuration::Seconds(5);
        TDuration SendTimeout = TDuration::Seconds(5);
        TDuration RecvTimeout = TDuration::Seconds(10);
        TDuration ReopenAfterIdle = TDuration::Minutes(1);
    };
}
