#include <passport/infra/libs/cpp/hbase/query.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NHbase;

Y_UNIT_TEST_SUITE(Query) {
    Y_UNIT_TEST(addParam) {
        TQuery q;

        UNIT_ASSERT_VALUES_EQUAL(q.Params.size(), 0);

        q.AddParam(std::string(""), std::string());
        UNIT_ASSERT_VALUES_EQUAL(q.Params.size(), 0);

        q.AddParam(std::string("some key"), std::string());
        UNIT_ASSERT_VALUES_EQUAL(q.Params.size(), 0);

        q.AddParam(std::string("some key"), std::string("some value"));
        UNIT_ASSERT_VALUES_EQUAL(q.Params.size(), 1);

        q.AddParam(std::string(""), std::string("some value2"));
        UNIT_ASSERT_VALUES_EQUAL(q.Params.size(), 2);

        UNIT_ASSERT_VALUES_EQUAL(
            q.PrintDebug(),
            "\n.type_=NHbase::TQuery::EType::Put,\n.row_=\"\",\n.params_={\n{\"some key\", \"some value\"},\n{\"\", \"some value2\"},\n},\n");
    }

    Y_UNIT_TEST(merge) {
        TQueries q;
        TQueries o1;
        TQueries o2;
        TQueries o3;
        TQueryArray arr1;
        TQueryArray arr2;
        TQueryArray arr3;
        TQueryArray arr4;

        UNIT_ASSERT_VALUES_EQUAL(0, q.ByTable.size());

        q.Merge({});
        UNIT_ASSERT_VALUES_EQUAL(0, q.ByTable.size());

        arr1.push_back(TQuery{.Row = "row#1.1"});
        arr1.push_back(TQuery{.Row = "row#1.2"});
        o1.ByTable["table#1"] = std::move(arr1);
        q.Merge(std::move(o1));
        UNIT_ASSERT_VALUES_EQUAL(1, q.ByTable.size());
        UNIT_ASSERT_VALUES_EQUAL(2, q.ByTable["table#1"].size());

        o2.ByTable["table#2"] = std::move(arr2);
        q.Merge(std::move(o2));
        UNIT_ASSERT_VALUES_EQUAL(2, q.ByTable.size());
        UNIT_ASSERT_VALUES_EQUAL(2, q.ByTable["table#1"].size());
        UNIT_ASSERT_VALUES_EQUAL(0, q.ByTable["table#2"].size());

        arr3.push_back(TQuery{.Row = "row#1.2"});
        arr4.push_back(TQuery{.Row = "row#2.1"});
        arr4.push_back(TQuery{.Row = "row#2.2"});
        o3.ByTable["table#1"] = std::move(arr3);
        o3.ByTable["table#2"] = std::move(arr4);
        q.Merge(std::move(o3));
        UNIT_ASSERT_VALUES_EQUAL(2, q.ByTable.size());
        UNIT_ASSERT_VALUES_EQUAL(3, q.ByTable["table#1"].size());
        UNIT_ASSERT_VALUES_EQUAL(2, q.ByTable["table#2"].size());
    }
}
