#pragma once

#include <passport/infra/libs/cpp/json/config.h>
#include <passport/infra/libs/cpp/xml/config.h>

#include <util/datetime/base.h>

#include <optional>

namespace NPassport::NDaemon {
    class TConfig {
    public:
        TConfig(const NXml::TConfig& config);
        TConfig(const NJson::TConfig& config);

        TConfig(TConfig&&) noexcept;
        ~TConfig();

        struct TDaemon {
            std::optional<ui16> MonitorPort;
            std::optional<TString> PidPath;
            bool EnableAllocatorDefrag = true;
        };

        struct TResponseTimeHeaders {
            TString InQueue;
            TString InHandler;
        };

        struct THttpBase {
            TString ListenAddress;
            size_t Threads = 0;
            size_t MaxConnections = 0;
            size_t MaxQueueSize = 0;
            TDuration MaxDelay;
            bool KeepAlive = true;
        };

        struct THttpCommon: THttpBase {
            struct TInterface {
                ui16 Port = 0;
                size_t ReuseCount = 0;
            };

            std::vector<TInterface> Interfaces;
            TResponseTimeHeaders ResponseTimeHeaders;
        };

        struct THttpUnistat: THttpBase {
            ui16 Port = 0;
            TString Path;
        };

        const TDaemon& GetDaemon() const {
            return Daemon_;
        }

        const THttpCommon& GetHttpCommon() const {
            return HttpCommon_;
        }

        const std::optional<THttpUnistat>& GetHttpUnistat() const {
            return HttpUnistat_;
        }

    private:
        static TDaemon ParseDaemon(const NXml::TConfig& config, const TString& xpath);
        static THttpCommon ParseHttpCommon(const NXml::TConfig& config, const TString& xpath);
        static std::optional<THttpUnistat> ParseHttpUnistat(const NXml::TConfig& config, const TString& xpath);
        static TResponseTimeHeaders ParseResponseTimeHeaders(const NXml::TConfig& config, const TString& xpath);

    private:
        static TDaemon ParseDaemon(const NJson::TConfig& config, const TString& jsonPoint);
        static THttpCommon ParseHttpCommon(const NJson::TConfig& config, const TString& jsonPoint);
        static std::optional<THttpUnistat> ParseHttpUnistat(const NJson::TConfig& config, const TString& jsonPoint);
        static TResponseTimeHeaders ParseResponseTimeHeaders(const NJson::TConfig& config, const TString& jsonPoint);

    private:
        TDaemon Daemon_;
        THttpCommon HttpCommon_;
        std::optional<THttpUnistat> HttpUnistat_;
    };
}
