#include "http_interface.h"

#include <passport/infra/libs/cpp/unistat/builder.h>

namespace NPassport::NDaemon {
    THttpInterface::THttpInterface(const TString& idx)
        : UnistatThreadsTotal_("http.threads.total_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatThreadsBusy_("http.threads.busy_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatQueueMax_("http.queue.max_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatQueueCurrent_("http.queue.current_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatQueueFailCurrent_("http.queue.fail.current_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatRequests_("http.requests_" + idx + "_dmmm")
        , UnistatClients_("http.clients_" + idx, NUnistat::NSuffix::AVVV)
        , UnistatFailRequests_("http.requests.fail_" + idx + "_dmmm")
        , UnistatException_("http.exceptions_" + idx + "_dmmm")
        , UnistatMaxConnection_("http.maxconnection_" + idx + "_dmmm")
    {
    }

    void THttpInterface::Start() {
        Y_ENSURE_EX(Srv_->Start(),
                    yexception() << "HttpDaemon failed to start: " << Srv_->GetError()
                                 << " [" << Srv_->GetErrorCode() << "]");

        TLog::Info() << "--- HTTP interface started: " << Srv_->Options().BindSockaddr.at(0).Port;
    }

    void THttpInterface::Wait() {
        Srv_->Wait();
        TLog::Info() << "--- HTTP interface stopped: " << Srv_->Options().BindSockaddr.at(0).Port;
    }

    void THttpInterface::Stop() {
        Srv_->Shutdown();
    }

    TString THttpInterface::Stats() const {
        const THttpServer::TOptions& opts = Srv_->Options();
        const TCallBackBase::TCounters& counters = Callback_->GetStats();
        TStringStream res;

        // Legacy (fastcgi-daemon)
        res << R"(<pool name="work_pool")";
        res << " threads=" << '"' << opts.nThreads << '"';
        res << " busy=" << '"' << counters.Busy.GetValue() << '"';
        res << " queue=" << '"' << opts.MaxQueueSize << '"';
        res << " current_queue=" << '"' << Srv_->GetRequestQueueSize() << '"';
        res << " all_tasks=" << '"' << counters.All.GetValue() << '"';

        // New data
        res << " clients=" << '"' << Srv_->GetClientCount() << '"';
        res << " fail_queue=" << '"' << Srv_->GetFailQueueSize() << '"';

        res << "/>\n";

        return res.Str();
    }

    void THttpInterface::AddUnistat(NUnistat::TBuilder& builder) const {
        const TCallBackBase::TCounters& counters = Callback_->GetStats();

        builder.AddRow(UnistatThreadsTotal_, Srv_->Options().nThreads);
        builder.AddRow(UnistatThreadsBusy_, counters.Busy.GetValue());
        builder.AddRow(UnistatQueueMax_, Srv_->Options().MaxQueueSize);
        builder.AddRow(UnistatQueueCurrent_, Srv_->GetRequestQueueSize());
        builder.AddRow(UnistatQueueFailCurrent_, Srv_->GetFailQueueSize());
        builder.AddRow(UnistatRequests_, counters.All.GetValue());
        builder.AddRow(UnistatClients_, (ui64)Srv_->GetClientCount());
        builder.AddRow(UnistatFailRequests_, counters.FailRequest.GetValue());
        builder.AddRow(UnistatException_, counters.Exception.GetValue());
        builder.AddRow(UnistatMaxConnection_, counters.MaxCon.GetValue());
    }
}
