#pragma once

#include "callback.h"
#include "config.h"

#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/options.h>

#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NDaemon {
    class THttpInterface {
    public:
        template <class T>
        static THttpInterface Create(T& s,
                                     const THttpServerOptions& opts,
                                     TDuration queueTimeout,
                                     const TConfig::TResponseTimeHeaders& headerNames = {},
                                     size_t idx = 0) {
            THttpInterface res(IntToString<10>(idx));

            res.Callback_ = std::make_unique<NDaemon::TCallBack<T>>(
                s,
                opts.RequestsThreadName,
                queueTimeout,
                headerNames);
            res.Srv_ = std::make_unique<THttpServer>(res.Callback_.get(), opts);

            return res;
        }

        void Start();
        void Wait();
        void Stop();

        TString Stats() const;
        void AddUnistat(NUnistat::TBuilder& builder) const;

    private:
        THttpInterface(const TString& idx);

    private:
        const NUnistat::TName UnistatThreadsTotal_;
        const NUnistat::TName UnistatThreadsBusy_;
        const NUnistat::TName UnistatQueueMax_;
        const NUnistat::TName UnistatQueueCurrent_;
        const NUnistat::TName UnistatQueueFailCurrent_;
        const TString UnistatRequests_;
        const NUnistat::TName UnistatClients_;
        const TString UnistatFailRequests_;
        const TString UnistatException_;
        const TString UnistatMaxConnection_;

        // Should be last members
        std::unique_ptr<TCallBackBase> Callback_;
        std::unique_ptr<THttpServer> Srv_;
    };
}
