#pragma once

#include "daemon.h"
#include "pid_file_holder.h"

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/openssl/init/init.h>

#include <util/stream/str.h>

namespace NPassport {
    template <class T, class Config = NXml::TConfig>
    int MainImpl(const char* threadName, int argc, char** argv) {
        try {
            TString configFile;

            NLastGetopt::TOpts opts;
            opts.AddHelpOption();
            opts.AddCharOption('c', "config file").StoreResult(&configFile).Required();
            opts.SetFreeArgsNum(0);

            InitOpenSSL();

            NLastGetopt::TOptsParseResult res(&opts, argc, argv);

            {
                std::unique_ptr<Config> config = std::make_unique<Config>(
                    Config::ReadFromFile(configFile));

                NPassport::NDaemon::TConfig daemonCfg(*config);
                const NPassport::NDaemon::TPidFileHolder pidHolder(daemonCfg);

                T service;
                service.Init(*config);

                NDaemon::THttpDaemon d(std::move(daemonCfg));
                d.Init(service, threadName);

                config.reset();

                d.Start();
            }
            TLog::Info() << "Service destroyed";
            TLog::Reset();

        } catch (const std::exception& e) {
            TLog::Error("Fatal error in main(): %s", e.what());
            return 1;
        }

        return 0;
    }
}
