#include "pid_file_holder.h"

#include <util/stream/file.h>
#include <util/system/fs.h>

namespace NPassport::NDaemon {
    TPidFileHolder::TPidFileHolder(const TConfig& config)
        : Filename_(config.GetDaemon().PidPath)
    {
        if (Filename_) {
            TFileOutput fileOutput(*Filename_);
            fileOutput << getpid();
        }
    }

    TPidFileHolder::~TPidFileHolder() {
        if (Filename_) {
            NFs::Remove(*Filename_);
        }
    }
}
