#include <passport/infra/libs/cpp/http_daemon/config.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NDaemon;

Y_UNIT_TEST_SUITE(DaemonConfig) {
    Y_UNIT_TEST(xmlLegacy) {
        const TConfig config(NXml::TConfig::ReadFromMemory(R"(<?xml version="1.0" ?>
       <config>
           <http_daemon>
               <listen_address>ya.ru</listen_address>
               <port reuse_count="2">456</port>
               <threads>96</threads>
               <port>457</port>
               <max_connections>4097</max_connections>
               <max_queue_size>8192</max_queue_size>
               <keep_alive>no</keep_alive>
               <max_delay>1123</max_delay>
           </http_daemon>

           <unistat>
               <listen_address>asdf</listen_address>
               <port>10180</port>
               <threads>3</threads>
               <max_connections>11</max_connections>
               <max_queue_size>12</max_queue_size>
               <keep_alive>yes</keep_alive>
               <max_delay>1001</max_delay>
               <path>/unistat</path>
           </unistat>

           <daemon>
               <pidfile>/var/run/passport/kek.pid</pidfile>
               <monitor_port>789</monitor_port>
           </daemon>
       </config>
    )"));

        UNIT_ASSERT(config.GetDaemon().PidPath);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().PidPath, "/var/run/passport/kek.pid");
        UNIT_ASSERT(config.GetDaemon().MonitorPort);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().MonitorPort, 789);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "ya.ru");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 96);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4097);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 8192);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1123));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, false);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 456);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].ReuseCount, 1);

        UNIT_ASSERT(config.GetHttpUnistat());

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->ListenAddress, "asdf");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Threads, 3);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxConnections, 11);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxQueueSize, 12);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxDelay, TDuration::MilliSeconds(1001));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Port, 10180);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Path, "/unistat");
    }

    Y_UNIT_TEST(xml) {
        const TConfig config(NXml::TConfig::ReadFromMemory(R"(<?xml version="1.0" ?>
       <config>
           <http_daemon>
               <listen_address>ya.ru</listen_address>
               <port reuse_count="2">456</port>
               <threads>1</threads>
               <port>457</port>
               <max_connections>4097</max_connections>
               <max_queue_size>8192</max_queue_size>
               <max_delay>1002</max_delay>
               <keep_alive>no</keep_alive>
           </http_daemon>

           <unistat>
               <listen_address>asdf</listen_address>
               <port>10180</port>
               <threads>3</threads>
               <max_connections>11</max_connections>
               <max_queue_size>12</max_queue_size>
               <keep_alive>yes</keep_alive>
               <max_delay>1001</max_delay>
               <path>/unistat</path>
           </unistat>

           <daemon>
               <pidfile>/var/run/passport/kek.pid</pidfile>
               <monitor_port>789</monitor_port>
           </daemon>
       </config>
    )"));

        UNIT_ASSERT(config.GetDaemon().PidPath);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().PidPath, "/var/run/passport/kek.pid");
        UNIT_ASSERT(config.GetDaemon().MonitorPort);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().MonitorPort, 789);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "ya.ru");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4097);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 8192);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1002));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, false);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 456);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].ReuseCount, 1);

        UNIT_ASSERT(config.GetHttpUnistat());

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->ListenAddress, "asdf");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Threads, 3);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxConnections, 11);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxQueueSize, 12);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxDelay, TDuration::MilliSeconds(1001));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Port, 10180);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Path, "/unistat");
    }

    Y_UNIT_TEST(xmlDefaults) {
        const TConfig config(NXml::TConfig::ReadFromMemory(R"(<?xml version="1.0" ?>
       <config>
           <http_daemon>
               <port>457</port>
           </http_daemon>

           <unistat>
               <port>10180</port>
               <path>/unistat</path>
           </unistat>
       </config>
    )"));

        UNIT_ASSERT(!config.GetDaemon().PidPath);
        UNIT_ASSERT(!config.GetDaemon().MonitorPort);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 4);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 1);

        UNIT_ASSERT(config.GetHttpUnistat());

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Threads, 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxConnections, 10);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxQueueSize, 10);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->KeepAlive, false);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Port, 10180);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Path, "/unistat");
    }

    Y_UNIT_TEST(xmlMinimal) {
        const TConfig config(NXml::TConfig::ReadFromMemory(R"(<?xml version="1.0" ?>
       <config>
           <http_daemon>
               <port>457</port>
           </http_daemon>
       </config>
    )"));

        UNIT_ASSERT(!config.GetDaemon().PidPath);
        UNIT_ASSERT(!config.GetDaemon().MonitorPort);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 4);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 1);

        UNIT_ASSERT(!config.GetHttpUnistat());
    }

    Y_UNIT_TEST(json) {
        const TConfig config(NJson::TConfig::ReadFromMemory(R"({
           "http_daemon": {
               "listen_address":"ya.ru",
               "ports": [
                   {
                       "port":456,
                       "reuse_count":2
                   },
                   {
                       "port":457
                   }
               ],
               "threads":1,
               "max_connections":4097,
               "max_queue_size":8192,
               "max_delay":1002,
               "keep_alive":false
           },
           "unistat": {
               "listen_address":"asdf",
               "port":10180,
               "threads":3,
               "max_connections":11,
               "max_queue_size":12,
               "keep_alive":true,
               "max_delay":1001,
               "path":"/unistat"
           },
           "daemon":{
               "pidfile":"/var/run/passport/kek.pid",
               "monitor_port":789
           }
       }
    )"));

        UNIT_ASSERT(config.GetDaemon().PidPath);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().PidPath, "/var/run/passport/kek.pid");
        UNIT_ASSERT(config.GetDaemon().MonitorPort);
        UNIT_ASSERT_VALUES_EQUAL(*config.GetDaemon().MonitorPort, 789);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "ya.ru");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4097);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 8192);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1002));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, false);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 456);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[1].ReuseCount, 1);

        UNIT_ASSERT(config.GetHttpUnistat());

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->ListenAddress, "asdf");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Threads, 3);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxConnections, 11);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxQueueSize, 12);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxDelay, TDuration::MilliSeconds(1001));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Port, 10180);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Path, "/unistat");
    }

    Y_UNIT_TEST(jsonDefaults) {
        const TConfig config(NJson::TConfig::ReadFromMemory(R"({
           "http_daemon": {
               "ports": [
                   {
                       "port":457
                   }
               ]
           },
           "unistat": {
               "port":10180,
               "path":"/unistat"
           }
       }
    )"));

        UNIT_ASSERT(!config.GetDaemon().PidPath);
        UNIT_ASSERT(!config.GetDaemon().MonitorPort);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 4);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 1);

        UNIT_ASSERT(config.GetHttpUnistat());

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Threads, 2);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxConnections, 10);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxQueueSize, 10);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->KeepAlive, false);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Port, 10180);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpUnistat()->Path, "/unistat");
    }

    Y_UNIT_TEST(jsonMinimal) {
        const TConfig config(NJson::TConfig::ReadFromMemory(R"({
           "http_daemon": {
               "ports": [
                   {
                       "port":457
                   }
               ]
           }
       }
    )"));

        UNIT_ASSERT(!config.GetDaemon().PidPath);
        UNIT_ASSERT(!config.GetDaemon().MonitorPort);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().ListenAddress, "localhost");
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Threads, 4);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxConnections, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxQueueSize, 4096);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().MaxDelay, TDuration::MilliSeconds(1000));
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().KeepAlive, true);

        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces.size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].Port, 457);
        UNIT_ASSERT_VALUES_EQUAL(config.GetHttpCommon().Interfaces[0].ReuseCount, 1);

        UNIT_ASSERT(!config.GetHttpUnistat());
    }
}
