#include "idn.h"

#include <contrib/libs/libidn2/include/idn2.h>

namespace NPassport::NIdn {
    struct TIdnaPtr {
        ~TIdnaPtr() {
            if (Ptr != nullptr) {
                free(Ptr);
            }
        }
        char* Ptr = nullptr;
    };

    TString UtfToPunycode(const char* buf) {
        TIdnaPtr dst;

        // Try to convert the string
        idn2_rc idnaRet = (idn2_rc)idn2_to_ascii_8z(buf, &dst.Ptr, 0);

        if (idnaRet != IDN2_OK) {
            return TString();
        }

        return TString(dst.Ptr);
    }

    TString UtfToPunycode(const TString& buf) {
        TString::const_iterator it;
        for (it = buf.cbegin(); it != buf.cend(); ++it) {
            if ((unsigned char)*it > 127) {
                break;
            }
        }
        if (it == buf.cend()) { // if no non-ascii characters return as is
            return buf;
        }

        return UtfToPunycode(buf.c_str());
    }

    TString PunycodeToUtf(const char* buf) {
        TIdnaPtr dst;

        // Try to convert the string
        idn2_rc idnaRet = (idn2_rc)idn2_to_unicode_8z8z(buf, &dst.Ptr, 0);
        if (idnaRet != IDN2_OK) {
            return TString();
        }

        return TString(dst.Ptr);
    }

    TString PunycodeToUtf(const TString& buf) {
        if (buf.find("xn--") == TString::npos) { // no conversion needed
            return buf;
        }

        return PunycodeToUtf(buf.c_str());
    }
}
