#include <passport/infra/libs/cpp/idn/idn.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NIdn;

Y_UNIT_TEST_SUITE(PasspIdn) {
    Y_UNIT_TEST(punycode) {
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("")));
        UNIT_ASSERT_VALUES_EQUAL("yandex.com", UtfToPunycode(TString("yandex.com")));
        UNIT_ASSERT_VALUES_EQUAL("some.xn--d1acufc.ru", UtfToPunycode(TString("some.домен.ru")));
        UNIT_ASSERT_VALUES_EQUAL("xn--d1acufc.xn--p1ai", UtfToPunycode(TString("домен.xn--p1ai")));
        UNIT_ASSERT_VALUES_EQUAL("xn--d1acpjx3f.xn--p1ai", UtfToPunycode(TString("яндекс.рф")));
        UNIT_ASSERT_VALUES_EQUAL("somestring", UtfToPunycode(TString("somestring")));
        UNIT_ASSERT_VALUES_EQUAL("xn--smstring-d8g2g", UtfToPunycode(TString("sоmеstring")));
        UNIT_ASSERT_VALUES_EQUAL("xn--d1acufc.xn--p1ai", UtfToPunycode(TString("xn--d1acufc.xn--p1ai")));
        UNIT_ASSERT_VALUES_EQUAL("tk--tk.tk", UtfToPunycode(TString("tk--tk.tk")));
        UNIT_ASSERT_VALUES_EQUAL("i----p.mail.narod.ru", UtfToPunycode(TString("i----p.mail.narod.ru")));
        UNIT_ASSERT_VALUES_EQUAL("no--reply.usa.cc", UtfToPunycode(TString("no--reply.usa.cc")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("❤.uz")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("☭.com")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("⌘.cn")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("Ⅎ.ru")));
        UNIT_ASSERT_VALUES_EQUAL("xn--ruru-6n9a", UtfToPunycode(TString("ru≠ru")));
        UNIT_ASSERT_VALUES_EQUAL("www.xn--gieen-nqa.de", UtfToPunycode(TString("www.Gießen.de")));
        UNIT_ASSERT_VALUES_EQUAL("xn--nxasmm1c.com", UtfToPunycode(TString("ΒόΛος.com")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode(TString("\xf0\x9f\xa4\xa3.uz")));
        UNIT_ASSERT_VALUES_EQUAL("", UtfToPunycode("yandex\xe0"));

        UNIT_ASSERT_VALUES_EQUAL("", PunycodeToUtf(TString("")));
        UNIT_ASSERT_VALUES_EQUAL("yandex.ru", PunycodeToUtf(TString("yandex.ru")));
        UNIT_ASSERT_VALUES_EQUAL("яндекс.рф", PunycodeToUtf(TString("яндекс.рф")));
        UNIT_ASSERT_VALUES_EQUAL("домен.рф", PunycodeToUtf(TString("xn--d1acufc.xn--p1ai")));
        UNIT_ASSERT_VALUES_EQUAL("sоmеstring", PunycodeToUtf(TString("xn--smstring-d8g2g")));
        UNIT_ASSERT_VALUES_EQUAL("mixed.домен.ру", PunycodeToUtf(TString("mixed.xn--d1acufc.ру")));
        UNIT_ASSERT_VALUES_EQUAL("yandexn--d1acufc.ru", PunycodeToUtf(TString("yandexn--d1acufc.ru")));
        UNIT_ASSERT_VALUES_EQUAL("🚽🚽🚽.ml", PunycodeToUtf(TString("xn--s78haa.ml")));
        UNIT_ASSERT_VALUES_EQUAL("😍.uz", PunycodeToUtf(TString("xn--r28h.uz")));
        UNIT_ASSERT_VALUES_EQUAL("🤣.uz", PunycodeToUtf(TString("xn--cq9h.uz")));
        UNIT_ASSERT_VALUES_EQUAL("tk--tk.tk", PunycodeToUtf(TString("tk--tk.tk")));
        UNIT_ASSERT_VALUES_EQUAL("i----p.mail.narod.ru", PunycodeToUtf(TString("i----p.mail.narod.ru")));
        UNIT_ASSERT_VALUES_EQUAL("no--reply.usa.cc", PunycodeToUtf(TString("no--reply.usa.cc")));
        UNIT_ASSERT_VALUES_EQUAL("\xD2\x89.tk", PunycodeToUtf(TString("xn--s3a.tk")));
        UNIT_ASSERT_VALUES_EQUAL("❤.uz", PunycodeToUtf(TString("xn--qei.uz")));
        UNIT_ASSERT_VALUES_EQUAL("Ⅎ.ru", PunycodeToUtf(TString("xn--f3g.ru")));
        UNIT_ASSERT_VALUES_EQUAL("ru≠ru", PunycodeToUtf(TString("xn--ruru-6n9a")));
        UNIT_ASSERT_VALUES_EQUAL("fass.de", PunycodeToUtf(TString("fass.de")));
        UNIT_ASSERT_VALUES_EQUAL("faß.de", PunycodeToUtf(TString("xn--fa-hia.de")));
        UNIT_ASSERT_VALUES_EQUAL("βόλοσ.com", PunycodeToUtf(TString("xn--nxasmq6b.com")));
        UNIT_ASSERT_VALUES_EQUAL("βόλος.com", PunycodeToUtf(TString("xn--nxasmm1c.com")));
    }
}
