#pragma once

#include "reader.h"

#include <contrib/libs/rapidjson/include/rapidjson/rapidjson.h>
#include <contrib/libs/rapidjson/include/rapidjson/schema.h>
#include <contrib/libs/rapidjson/include/rapidjson/stringbuffer.h>

#include <util/generic/yexception.h>
#include <util/stream/str.h>

namespace NPassport::NJson {
    class TJsonSchema {
    public:
        TJsonSchema(const TStringBuf sch)
            : Sch_(Init(sch))
        {
        }

        bool Validate(const rapidjson::Value& value, TString* err = nullptr) const {
            rapidjson::SchemaValidator validator(Sch_);
            if (value.Accept(validator)) {
                return true;
            }

            if (err) {
                TStringStream s;

                rapidjson::StringBuffer sb;
                validator.GetInvalidSchemaPointer().StringifyUriFragment(sb);
                s << "schema: " << TStringBuf(sb.GetString(), sb.GetSize());
                sb.Clear();

                const char* keyword = validator.GetInvalidSchemaKeyword();
                s << ". keyword: " << (keyword ? keyword : "");

                validator.GetInvalidDocumentPointer().StringifyUriFragment(sb);
                s << ". input: " << TStringBuf(sb.GetString(), sb.GetSize());

                *err = s.Str();
            }

            return false;
        }

    private:
        static rapidjson::SchemaDocument Init(const TStringBuf sch) {
            rapidjson::Document sd;
            Y_ENSURE(TReader::DocumentAsObject(sch, sd), "schema must be valid json object");
            return rapidjson::SchemaDocument(sd);
        }

    private:
        rapidjson::SchemaDocument Sch_;
    };
}
