#include <passport/infra/libs/cpp/json/reader.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NJson;
using namespace NPassport;

Y_UNIT_TEST_SUITE(PasspJsonReader) {
    Y_UNIT_TEST(jsonReadArray) {
        rapidjson::Document doc;
        UNIT_ASSERT(!TReader::DocumentAsObject(R"([])", doc));
        UNIT_ASSERT(TReader::DocumentAsArray(R"([])", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(!TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));
    }

    Y_UNIT_TEST(jsonReadObjectEmpty) {
        rapidjson::Document doc;
        UNIT_ASSERT(!TReader::DocumentAsArray(R"({})", doc));
        UNIT_ASSERT(TReader::DocumentAsObject(R"({})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(!TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));
    }

    Y_UNIT_TEST(jsonReadObjectString) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":"abc"})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));

        UNIT_ASSERT_VALUES_EQUAL("abc", s);
        UNIT_ASSERT_STRINGS_EQUAL("abc", c);
    }

    Y_UNIT_TEST(jsonReadObjectArray) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":[]})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));
    }

    Y_UNIT_TEST(jsonReadObjectObject) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":{}})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));
    }

    Y_UNIT_TEST(jsonReadObjectInt) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":123})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(TReader::MemberAsDouble(doc, "key", d));

        UNIT_ASSERT_VALUES_EQUAL(123, i);
        UNIT_ASSERT_VALUES_EQUAL(123, ui);
        UNIT_ASSERT_VALUES_EQUAL(123, ui_);
        UNIT_ASSERT_VALUES_EQUAL(123, d);
    }

    Y_UNIT_TEST(jsonReadObjectDouble) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":123.0625})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(TReader::MemberAsDouble(doc, "key", d));

        UNIT_ASSERT_VALUES_EQUAL(123.0625, d);

        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":-123})", doc));
        UNIT_ASSERT(TReader::MemberAsDouble(doc, "key", d));
        UNIT_ASSERT_VALUES_EQUAL(-123, d);
    }

    Y_UNIT_TEST(jsonReadObjectBool) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":false})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));

        UNIT_ASSERT(!b);
    }

    Y_UNIT_TEST(jsonReadObjectNull) {
        rapidjson::Document doc;
        UNIT_ASSERT(TReader::DocumentAsObject(R"({"key":null})", doc));

        const rapidjson::Value* v = nullptr;
        const char* c = nullptr;
        TString s;
        int i = 0;
        ui32 ui = 0;
        i64 i_ = 0;
        ui64 ui_ = 0;
        bool b = false;
        double d = 0;
        UNIT_ASSERT(TReader::Member(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", c));
        UNIT_ASSERT(!TReader::MemberAsString(doc, "key", s));
        UNIT_ASSERT(!TReader::MemberAsArray(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsObject(doc, "key", v));
        UNIT_ASSERT(!TReader::MemberAsInt(doc, "key", i));
        UNIT_ASSERT(!TReader::MemberAsUInt(doc, "key", ui));
        UNIT_ASSERT(!TReader::MemberAsInt64(doc, "key", i_));
        UNIT_ASSERT(!TReader::MemberAsUInt64(doc, "key", ui_));
        UNIT_ASSERT(!TReader::MemberAsBool(doc, "key", b));
        UNIT_ASSERT(TReader::MemberAsNull(doc, "key", b));
        UNIT_ASSERT(!TReader::MemberAsDouble(doc, "key", d));
    }
}
