#include <passport/infra/libs/cpp/json/writer.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NJson;
using namespace NPassport;

Y_UNIT_TEST_SUITE(PasspJsonWriter) {
    Y_UNIT_TEST(jsonWriteWrap) {
        TString buf;
        {
            TString s = "abc";
            TWriter wr(buf);
            TObject root(wr);
            root.Add("k1", int(-123));
            root.Add("k2", i64(456));
            root.Add("k3", (unsigned int)123);
            root.Add("k4", ui64(789));
            root.Add("k5", false);
            root.Add("k6", s);
            root.Add("k7", (const char*)nullptr);
            rapidjson::Document doc;
            doc.Parse(R"({"obj":89})");
            root.Add("k9", doc);
            root.Add("k10", "{\"lol\":\"kek\"}");
            root.Add("k11", 3.1415);
            {
                TObject k_obj(root, "k_obj");
                k_obj.Add("k1", true);
            }
            {
                TArray k_arr(root, "k_arr");
                k_arr.Add("hello");
                k_arr.Add("world");
            }
            {
                TObject k_obj(root, "");
                k_obj.Add("k2", (char*)nullptr);
            }
            {
                TArray k_arr(root, "");
                k_arr.Add("hello");
                k_arr.Add("again");
                k_arr.Add(nullptr);
            }
        }
        UNIT_ASSERT_VALUES_EQUAL(R"({"k1":-123,"k2":456,"k3":123,"k4":789,"k5":false,"k6":"abc",)"
                                 R"("k7":null,"k9":{"obj":89},"k10":"{\"lol\":\"kek\"}","k11":3.1415,)"
                                 R"("k_obj":{"k1":true},"k_arr":["hello","world"],"":{"k2":null},"":["hello","again",null]})",
                                 buf);
        buf.clear();

        {
            TString s = "abc";
            TWriter wr(buf);
            TArray arr(wr);
            arr.Add((unsigned int)123);
            arr.Add(ui64(789));
            arr.Add(s);
            arr.Add("{\"lol\":\"kek\"}");
            arr.Add(3.1415);
            {
                TObject k_obj(arr);
                k_obj.Add("k1", true);
            }
            {
                TArray k_arr(arr);
                k_arr.Add("hello");
                k_arr.Add("world");
            }
            {
                TObject k_obj(arr);
                k_obj.Add("k2", (char*)nullptr);
            }
            {
                TArray k_arr(arr);
                k_arr.Add("hello");
                k_arr.Add("again");
                k_arr.Add(nullptr);
            }
            {
                TObject k_obj(arr);
                k_obj.Add("k2", true);
            }
            {
                TArray k_arr(arr);
                k_arr.Add(false);
            }
        }
        UNIT_ASSERT_VALUES_EQUAL(R"([123,789,"abc","{\"lol\":\"kek\"}",3.1415,)"
                                 R"({"k1":true},["hello","world"],{"k2":null},["hello","again",null],{"k2":true},[false]])",
                                 buf);
        buf.clear();
    }

    Y_UNIT_TEST(jsonWriteUtf8) {
        TString buf;
        {
            TWriter wr(buf);
            TObject root(wr);
            root.Add("k", "௵");
        }
        UNIT_ASSERT_VALUES_EQUAL(R"({"k":"\u0BF5"})",
                                 buf);
        buf.clear();
    }

    Y_UNIT_TEST(jsonWriteBadUtf) {
        TString buf;

        {
            std::string s = {'a', static_cast<char>(0xff), 'b'};
            TWriter wr(buf);
            TObject root(wr);
            root.Add("k", s);
            root.Add("k\xff"
                     "ey",
                     "v\xff"
                     "a\xf0\xf0lue");
        }
        UNIT_ASSERT_VALUES_EQUAL(R"({"k":"ab","key":"value"})",
                                 buf);
        buf.clear();

        {
            std::string s = {'a', static_cast<char>(0xf0), static_cast<char>(0xe4), 'b'};
            TWriter wr(buf);
            TArray root(wr);
            root.Add(s);
            root.Add("x\xffy\xf0z");
        }
        UNIT_ASSERT_VALUES_EQUAL(R"(["ab","xyz"])",
                                 buf);
        buf.clear();
    }
}
