#include "status.h"

namespace NPassport::NJuggler {
    TStatus::operator TString() const {
        return NUtils::CreateStr(ui16(StatusCode_), ";", Message_);
    }

    bool TStatus::operator==(const ECode& o) const {
        return StatusCode_ == o;
    }

    bool TStatus::operator==(const TStatus& o) const {
        return StatusCode() == o.StatusCode() && Message() == o.Message();
    }

    void TStatus::Update(TStatus&& status) {
        Update(status.StatusCode_, status.Message_);
    }

    void TStatus::Update(NTvmAuth::TClientStatus&& clientStatus) {
        ECode code;
        switch (clientStatus.GetCode()) {
            case NTvmAuth::TClientStatus::ECode::Ok:
                code = ECode::Ok;
                break;
            case NTvmAuth::TClientStatus::ECode::Warning:
            case NTvmAuth::TClientStatus::ECode::IncompleteTicketsSet:
                code = ECode::Warning;
                break;
            case NTvmAuth::TClientStatus::ECode::Error:
                code = ECode::Critical;
                break;
        }
        Update(code, clientStatus.GetLastError());
    }
}
