#pragma once

#include "passport/infra/libs/cpp/utils/string/string_utils.h"

#include <library/cpp/tvmauth/client/client_status.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NJuggler {
    enum class ECode {
        Ok = 0,
        Warning = 1,
        Critical = 2,
    };

    class TStatus: TMoveOnly {
    public:
        TStatus() = default;

        template <typename... Str>
        explicit TStatus(ECode code, const Str&... args)
            : StatusCode_(code)
        {
            Message_ = NUtils::CreateStr(args...);
        }

        ECode StatusCode() const {
            return StatusCode_;
        }

        const TString& Message() const {
            return Message_;
        }

        operator TString() const;

        bool operator==(const ECode& o) const;

        bool operator==(const TStatus& o) const;

        void Update(TStatus&& status);

        void Update(NTvmAuth::TClientStatus&& clientStatus);

        template <typename... Str>
        void Update(ECode code, const Str&... args) {
            if (code > StatusCode_) {
                StatusCode_ = code;
                Message_ = NUtils::CreateStr(args...);
            }
        }

    private:
        ECode StatusCode_ = ECode::Ok;
        TString Message_ = "OK";
    };
}
