#include <passport/infra/libs/cpp/juggler/status.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NJuggler;

template <>
void Out<TStatus>(IOutputStream& o, const TStatus& value) {
    o << "status: (" << value.StatusCode() << ", " << value.Message() << ")";
}

Y_UNIT_TEST_SUITE(JugglerStatus) {
    Y_UNIT_TEST(Initialization) {
        UNIT_ASSERT_NO_EXCEPTION(TStatus());
        UNIT_ASSERT_EQUAL(TStatus().StatusCode(), ECode::Ok);
        UNIT_ASSERT_EQUAL(TStatus().Message(), "OK");
        TStatus status(ECode::Critical, "asdf1");
        UNIT_ASSERT_EQUAL(status, ECode::Critical);
        UNIT_ASSERT_EQUAL(status.StatusCode(), ECode::Critical);
        UNIT_ASSERT_EQUAL(status.Message(), "asdf1");

        TStatus status2(ECode::Warning, "asdf2", "asdf3", 123, 5);
        UNIT_ASSERT_EQUAL(status2, ECode::Warning);
        UNIT_ASSERT_EQUAL(status2.StatusCode(), ECode::Warning);
        UNIT_ASSERT_EQUAL(status2.Message(), "asdf2asdf31235");
    }

    Y_UNIT_TEST(Compouding) {
        TStatus statusOk1(ECode::Ok, "asdf1extra2");
        TStatus statusWarning1(ECode::Warning, "asdf3");
        TStatus statusCritical1(ECode::Critical, "asdf5");

        TStatus status(ECode::Ok, "asdf1", "extra2");
        UNIT_ASSERT_VALUES_EQUAL(status, statusOk1);
        status.Update(TStatus(ECode::Ok, "asdf2"));
        UNIT_ASSERT_VALUES_EQUAL(status, statusOk1);
        status.Update(TStatus(ECode::Warning, "asdf3"));
        UNIT_ASSERT_VALUES_EQUAL(status, statusWarning1);
        status.Update(TStatus(ECode::Warning, "asdf4"));
        UNIT_ASSERT_VALUES_EQUAL(status, statusWarning1);
        status.Update(ECode::Critical, "asdf5");
        UNIT_ASSERT_VALUES_EQUAL(status, statusCritical1);
        status.Update(TStatus(ECode::Critical, "asdf6"));
        UNIT_ASSERT_VALUES_EQUAL(status, statusCritical1);
        status.Update(TStatus(ECode::Warning, "asdf7"));
        UNIT_ASSERT_VALUES_EQUAL(status, statusCritical1);
        status.Update(ECode::Ok, "asdf8");
        UNIT_ASSERT_VALUES_EQUAL(status, statusCritical1);
    }

    Y_UNIT_TEST(TvmConversion) {
        TStatus status;
        status.Update(NTvmAuth::TClientStatus(NTvmAuth::TClientStatus::ECode::Ok, "asdf1"));
        UNIT_ASSERT_VALUES_EQUAL(status, TStatus(ECode::Ok, "OK"));
        status.Update(NTvmAuth::TClientStatus(NTvmAuth::TClientStatus::ECode::Warning, "asdf2"));
        UNIT_ASSERT_VALUES_EQUAL(status, TStatus(ECode::Warning, "asdf2"));
        status.Update(NTvmAuth::TClientStatus(NTvmAuth::TClientStatus::ECode::Error, "asdf3"));
        UNIT_ASSERT_VALUES_EQUAL(status, TStatus(ECode::Critical, "asdf3"));
    }
}
