#include <passport/infra/libs/cpp/logbroker/entity_parsers/yasms_private.h>

#include <passport/infra/libs/cpp/utils/ipaddr.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NEntityParsers;

Y_UNIT_TEST_SUITE(YasmsPrivateParser) {
    Y_UNIT_TEST(getTimestamp) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetTimestamp(tskv),
                                       yexception,
                                       "no field 'unixtimef'");

        tskv.Reset("tskv\tunixtimef=adc");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetTimestamp(tskv),
                                       yexception,
                                       "invalid number in 'unixtimef': 'adc'");

        tskv.Reset("tskv\tunixtimef=100500.005");
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-01-02T03:55:00.005000Z"),
                                 TYasmsPrivateBaseParser::GetTimestamp(tskv));

        tskv.Reset("tskv\tunixtimef=100500");
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-01-02T03:55:00.000000Z"),
                                 TYasmsPrivateBaseParser::GetTimestamp(tskv));
    }

    Y_UNIT_TEST(getUnixtime) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetUnixtime(tskv),
                                       yexception,
                                       "no field 'unixtime'");

        tskv.Reset("tskv\tunixtime=adc");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetUnixtime(tskv),
                                       yexception,
                                       "invalid number in 'unixtime': 'adc'");

        tskv.Reset("tskv\tunixtime=100500.005");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetUnixtime(tskv),
                                       yexception,
                                       "invalid number in 'unixtime': '100500.005'");

        tskv.Reset("tskv\tunixtime=100500");
        UNIT_ASSERT_VALUES_EQUAL(100500,
                                 TYasmsPrivateBaseParser::GetUnixtime(tskv));
    }

    Y_UNIT_TEST(getAction) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetAction(tskv),
                                       yexception,
                                       "no field 'action'");

        tskv.Reset("tskv\taction=kek");
        UNIT_ASSERT_VALUES_EQUAL("kek",
                                 TYasmsPrivateBaseParser::GetAction(tskv));
    }

    Y_UNIT_TEST(getEncryptedText) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_VALUES_EQUAL("",
                                 TYasmsPrivateBaseParser::GetEncryptedText(tskv));

        tskv.Reset("tskv\tencryptedtext=kek");
        UNIT_ASSERT_VALUES_EQUAL("kek",
                                 TYasmsPrivateBaseParser::GetEncryptedText(tskv));
    }

    Y_UNIT_TEST(isSms) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT(!TYasmsPrivateBaseParser::IsSms(tskv));

        tskv.Reset("tskv\tsms=kek");
        UNIT_ASSERT(!TYasmsPrivateBaseParser::IsSms(tskv));

        tskv.Reset("tskv\tsms=0");
        UNIT_ASSERT(!TYasmsPrivateBaseParser::IsSms(tskv));

        tskv.Reset("tskv\tsms=2");
        UNIT_ASSERT(!TYasmsPrivateBaseParser::IsSms(tskv));

        tskv.Reset("tskv\tsms=1");
        UNIT_ASSERT(TYasmsPrivateBaseParser::IsSms(tskv));
    }

    Y_UNIT_TEST(getNumber) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_VALUES_EQUAL("",
                                 TYasmsPrivateBaseParser::GetNumber(tskv));

        tskv.Reset("tskv\tnumber=kek");
        UNIT_ASSERT_VALUES_EQUAL("kek",
                                 TYasmsPrivateBaseParser::GetNumber(tskv));
    }

    Y_UNIT_TEST(getUid) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_VALUES_EQUAL(0,
                                 TYasmsPrivateBaseParser::GetUid(tskv));

        tskv.Reset("tskv\tuid=adc");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetUid(tskv),
                                       yexception,
                                       "invalid number in 'uid': 'adc'");

        tskv.Reset("tskv\tuid=100500");
        UNIT_ASSERT_VALUES_EQUAL(100500,
                                 TYasmsPrivateBaseParser::GetUid(tskv));
    }

    Y_UNIT_TEST(getGlobalSmsId) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetGlobalSmsId(tskv),
                                       yexception,
                                       "no field 'global_smsid'");

        tskv.Reset("tskv\tglobal_smsid=kek");
        UNIT_ASSERT_VALUES_EQUAL("kek",
                                 TYasmsPrivateBaseParser::GetGlobalSmsId(tskv));
    }

    Y_UNIT_TEST(getUserIp) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT(!TYasmsPrivateBaseParser::GetUserIp(tskv));

        tskv.Reset("tskv\tuser_ip=kek");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TYasmsPrivateBaseParser::GetUserIp(tskv),
                                       yexception,
                                       "invalid ip address in 'user_ip': 'kek'");

        tskv.Reset("tskv\tuser_ip=127.0.0.1");
        UNIT_ASSERT_VALUES_EQUAL(NUtils::TIpAddr("127.0.0.1"),
                                 *TYasmsPrivateBaseParser::GetUserIp(tskv));
    }

    Y_UNIT_TEST(getUserAgent) {
        NRowParsers::TTskvRow tskv;

        UNIT_ASSERT_VALUES_EQUAL("",
                                 TYasmsPrivateBaseParser::GetUserAgent(tskv));

        tskv.Reset("tskv\tuser_agent=k\\tek");
        UNIT_ASSERT_VALUES_EQUAL("k\tek",
                                 TYasmsPrivateBaseParser::GetUserAgent(tskv));
    }
}
