#include "yasms_private.h"

#include <passport/infra/libs/cpp/utils/ipaddr.h>

namespace NPassport::NEntityParsers {
    TInstant TYasmsPrivateBaseParser::GetTimestamp(NRowParsers::TTskvRow& tskv) {
        return tskv.GetUnixtime("unixtimef");
    }

    time_t TYasmsPrivateBaseParser::GetUnixtime(NRowParsers::TTskvRow& tskv) {
        time_t res;
        tskv.GetNum("unixtime", res);
        return res;
    }

    TStringBuf TYasmsPrivateBaseParser::GetAction(NRowParsers::TTskvRow& tskv) {
        return tskv.GetField("action");
    }

    TStringBuf TYasmsPrivateBaseParser::GetEncryptedText(NRowParsers::TTskvRow& tskv) {
        return tskv.GetOptionalField("encryptedtext");
    }

    bool TYasmsPrivateBaseParser::IsSms(NRowParsers::TTskvRow& tskv) {
        return tskv.GetOptionalField("sms") == "1";
    }

    TStringBuf TYasmsPrivateBaseParser::GetNumber(NRowParsers::TTskvRow& tskv) {
        return tskv.GetOptionalField("number");
    }

    ui64 TYasmsPrivateBaseParser::GetUid(NRowParsers::TTskvRow& tskv) {
        ui64 res = 0;
        tskv.GetOptionalNum("uid", res);
        return res;
    }

    TStringBuf TYasmsPrivateBaseParser::GetGlobalSmsId(NRowParsers::TTskvRow& tskv) {
        return tskv.GetField("global_smsid");
    }

    std::optional<NUtils::TIpAddr> TYasmsPrivateBaseParser::GetUserIp(NRowParsers::TTskvRow& tskv) {
        return tskv.GetOptionalIp("user_ip");
    }

    TString TYasmsPrivateBaseParser::GetUserAgent(NRowParsers::TTskvRow& tskv) {
        return TString(tskv.GetOptionalField("user_agent"));
    }
}
