#pragma once

#include <passport/infra/libs/cpp/logbroker/row_parsers/tskv_row.h>

#include <util/datetime/base.h>

namespace NPassport::NEntityParsers {
    class TYasmsPrivateBaseParser {
    public:
        static TInstant GetTimestamp(NRowParsers::TTskvRow& tskv);
        static time_t GetUnixtime(NRowParsers::TTskvRow& tskv);
        static TStringBuf GetAction(NRowParsers::TTskvRow& tskv);
        static TStringBuf GetEncryptedText(NRowParsers::TTskvRow& tskv);
        static bool IsSms(NRowParsers::TTskvRow& tskv);
        static TStringBuf GetNumber(NRowParsers::TTskvRow& tskv);
        static ui64 GetUid(NRowParsers::TTskvRow& tskv);
        static TStringBuf GetGlobalSmsId(NRowParsers::TTskvRow& tskv);
        static std::optional<NUtils::TIpAddr> GetUserIp(NRowParsers::TTskvRow& tskv);
        static TString GetUserAgent(NRowParsers::TTskvRow& tskv);
    };
}
