#pragma once

#include <passport/infra/libs/cpp/utils/log/file_logger.h>

#include <util/string/subst.h>

#include <map>

namespace NPassport::NLb {
    template <class LogTypeTraits>
    struct TBadLineLoggers {
        void Init(const TString& baseFilename, const std::vector<TString>& types) {
            for (const TString& type : types) {
                TString filename = baseFilename;
                SubstGlobal(filename, "%s", type);

                Loggers_.emplace(
                    LogTypeTraits::FromString(type),
                    std::make_unique<NUtils::TFileLogger>(filename, "ERROR", false));
            }
        }

        NUtils::TFileLogger& GetLogger(typename LogTypeTraits::TType logType) const {
            auto it = Loggers_.find(logType);

            Y_VERIFY(it != Loggers_.end(),
                     "missing logger for '%s'",
                     LogTypeTraits::ToString(logType).c_str());

            return *it->second;
        }

    private:
        std::map<typename LogTypeTraits::TType, std::unique_ptr<NUtils::TFileLogger>> Loggers_;
    };
}
